/*
 * Decompiled with CFR 0.152.
 */
package com.endreborn.world;

import com.endreborn.init.ModBlocks;
import com.endreborn.init.ModPieces;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class EndShipwreckPieces {
    public static final ResourceLocation END_SHIPWRECK_LOOT = new ResourceLocation("endreborn", "chests/end_shipwreck");
    private static final ResourceLocation[] STRUCTURES = new ResourceLocation[]{new ResourceLocation("endreborn:end_shipwreck"), new ResourceLocation("endreborn:end_shipruin")};

    public static void addPieces(StructureTemplateManager manager, BlockPos pos, Rotation rotation, StructurePieceAccessor pieceList, Structure.GenerationContext generationContext, RandomSource random) {
        pieceList.m_142679_((StructurePiece)new Piece(manager, (ResourceLocation)Util.m_214670_((Object[])STRUCTURES, (RandomSource)random), pos, rotation));
    }

    public static class Piece
    extends TemplateStructurePiece {
        public Piece(StructureTemplateManager manager, ResourceLocation resourceLocation, BlockPos position, Rotation rotation) {
            super(ModPieces.END_SHIPWRECK, 0, manager, resourceLocation, resourceLocation.toString(), Piece.loadTemplate(manager, resourceLocation, rotation), position.m_7918_(0, -4, 0));
        }

        public Piece(StructurePieceSerializationContext serializationContext, CompoundTag compoundNBT) {
            super(ModPieces.END_SHIPWRECK, compoundNBT, serializationContext.f_226956_(), placementSettings -> {
                ResourceLocation templateLocation = new ResourceLocation(compoundNBT.m_128461_("Template"));
                Rotation rotation = Rotation.valueOf((String)compoundNBT.m_128461_("Rot"));
                return Piece.loadTemplate(serializationContext.f_226956_(), templateLocation, rotation);
            });
        }

        public void m_213694_(WorldGenLevel worldIn, StructureManager p_229138_, ChunkGenerator p_229139_, RandomSource rand, BoundingBox p_229141_, ChunkPos p_229142_, BlockPos pos) {
            super.m_213694_(worldIn, p_229138_, p_229139_, rand, p_229141_, p_229142_, pos);
            for (int j = 0; j < 8; ++j) {
                BlockPos blockpos = pos.m_7918_(rand.m_188503_(4), rand.m_188503_(6), rand.m_188503_(4));
                if (worldIn.m_8055_(blockpos).m_60734_() != Blocks.f_50492_) continue;
                worldIn.m_7731_(blockpos, ((Block)ModBlocks.CRACKED_END_BRICKS.get()).m_49966_(), 2);
            }
        }

        private static StructurePlaceSettings loadTemplate(StructureTemplateManager manager, ResourceLocation resourceLocation, Rotation rotation) {
            StructureTemplate template = manager.m_230359_(resourceLocation);
            BlockPos pivot = new BlockPos(template.m_163801_().m_123341_() / 2, 0, template.m_163801_().m_123343_() / 2);
            return new StructurePlaceSettings().m_74379_(rotation).m_74377_(Mirror.NONE).m_74385_(pivot).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74048_);
        }

        protected void m_183620_(StructurePieceSerializationContext serializationContext, CompoundTag compoundNBT) {
            super.m_183620_(serializationContext, compoundNBT);
            compoundNBT.m_128359_("Rot", this.f_73657_.m_74404_().name());
        }

        protected void m_213704_(String function, BlockPos pos, ServerLevelAccessor worldIn, RandomSource rand, BoundingBox sbb) {
            BlockPos blockpos;
            if (function.startsWith("Chest") && sbb.m_71051_((Vec3i)(blockpos = pos.m_7495_()))) {
                RandomizableContainer.m_307915_((BlockGetter)worldIn, (RandomSource)rand, (BlockPos)blockpos, (ResourceLocation)END_SHIPWRECK_LOOT);
            }
        }
    }
}

