/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.volume;

import com.google.common.collect.Lists;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumesScreen;
import de.maxhenkel.voicechat.gui.volume.CategoryVolumeEntry;
import de.maxhenkel.voicechat.gui.volume.PlayerVolumeEntry;
import de.maxhenkel.voicechat.gui.volume.VolumeEntry;
import de.maxhenkel.voicechat.gui.widgets.ListScreenListBase;
import de.maxhenkel.voicechat.plugins.impl.VolumeCategoryImpl;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class AdjustVolumeList
extends ListScreenListBase<VolumeEntry> {
    protected AdjustVolumesScreen screen;
    protected final List<VolumeEntry> entries;
    protected String filter;

    public AdjustVolumeList(int width, int height, int top, int itemSizee, AdjustVolumesScreen screen) {
        super(width, height, top, itemSizee);
        this.screen = screen;
        this.entries = Lists.newArrayList();
        this.filter = "";
        this.m_93488_(false);
        this.updateEntryList();
    }

    public static void update() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof AdjustVolumesScreen) {
            AdjustVolumesScreen volumesScreen = (AdjustVolumesScreen)screen;
            volumesScreen.volumeList.updateEntryList();
        }
    }

    public void updateEntryList() {
        List<PlayerState> onlinePlayers = ClientManager.getPlayerStateManager().getPlayerStates(false);
        this.entries.clear();
        for (VolumeCategoryImpl category : ClientManager.getCategoryManager().getCategories()) {
            this.entries.add(new CategoryVolumeEntry(category, this.screen));
        }
        for (PlayerState state : onlinePlayers) {
            this.entries.add(new PlayerVolumeEntry(state, this.screen));
        }
        if (VoicechatClient.CLIENT_CONFIG.offlinePlayerVolumeAdjustment.get().booleanValue()) {
            this.addOfflinePlayers(onlinePlayers);
        }
        this.updateFilter();
    }

    private void addOfflinePlayers(Collection<PlayerState> onlinePlayers) {
        for (UUID uuid : VoicechatClient.VOLUME_CONFIG.getPlayerVolumes().keySet()) {
            String name;
            if (uuid.equals(Util.f_137441_) || onlinePlayers.stream().anyMatch(state -> uuid.equals(state.getUuid())) || (name = VoicechatClient.USERNAME_CACHE.getUsername(uuid)) == null) continue;
            this.entries.add(new PlayerVolumeEntry(new PlayerState(uuid, name, false, true), this.screen));
        }
    }

    public void updateFilter() {
        this.m_93516_();
        ArrayList<VolumeEntry> filteredEntries = new ArrayList<VolumeEntry>(this.entries);
        if (!this.filter.isEmpty()) {
            filteredEntries.removeIf(volumeEntry -> {
                if (volumeEntry instanceof PlayerVolumeEntry) {
                    PlayerVolumeEntry playerVolumeEntry = (PlayerVolumeEntry)((Object)volumeEntry);
                    return playerVolumeEntry.getState() == null || !playerVolumeEntry.getState().getName().toLowerCase(Locale.ROOT).contains(this.filter);
                }
                if (volumeEntry instanceof CategoryVolumeEntry) {
                    CategoryVolumeEntry categoryVolumeEntry = (CategoryVolumeEntry)((Object)volumeEntry);
                    return !categoryVolumeEntry.getCategory().getName().toLowerCase(Locale.ROOT).contains(this.filter);
                }
                return true;
            });
        }
        filteredEntries.sort((e1, e2) -> {
            if (!((Object)e1).getClass().equals(((Object)e2).getClass())) {
                if (e1 instanceof PlayerVolumeEntry) {
                    return 1;
                }
                return -1;
            }
            return this.volumeEntryToString((VolumeEntry)((Object)e1)).compareToIgnoreCase(this.volumeEntryToString((VolumeEntry)((Object)e2)));
        });
        if (this.filter.isEmpty()) {
            filteredEntries.add(0, new PlayerVolumeEntry(null, this.screen));
        }
        this.m_5988_(filteredEntries);
    }

    private String volumeEntryToString(VolumeEntry entry) {
        if (entry instanceof PlayerVolumeEntry) {
            PlayerVolumeEntry playerVolumeEntry = (PlayerVolumeEntry)entry;
            return playerVolumeEntry.getState() == null ? "" : playerVolumeEntry.getState().getName();
        }
        if (entry instanceof CategoryVolumeEntry) {
            CategoryVolumeEntry categoryVolumeEntry = (CategoryVolumeEntry)entry;
            return categoryVolumeEntry.getCategory().getName();
        }
        return "";
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.updateFilter();
    }

    public boolean isEmpty() {
        return this.m_6702_().isEmpty();
    }
}

