/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import de.maxhenkel.voicechat.gui.CreateGroupScreen;
import de.maxhenkel.voicechat.gui.EnterPasswordScreen;
import de.maxhenkel.voicechat.gui.group.JoinGroupEntry;
import de.maxhenkel.voicechat.gui.group.JoinGroupList;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import de.maxhenkel.voicechat.net.JoinGroupPacket;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;

public class JoinGroupScreen
extends ListScreenBase {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_join_group.png");
    protected static final Component TITLE = Component.m_237115_((String)"gui.voicechat.join_create_group.title");
    protected static final Component CREATE_GROUP = Component.m_237115_((String)"message.voicechat.create_group_button");
    protected static final Component JOIN_CREATE_GROUP = Component.m_237115_((String)"message.voicechat.join_create_group");
    protected static final Component NO_GROUPS = Component.m_237115_((String)"message.voicechat.no_groups").m_130940_(ChatFormatting.GRAY);
    protected static final int HEADER_SIZE = 16;
    protected static final int FOOTER_SIZE = 32;
    protected static final int UNIT_SIZE = 18;
    protected static final int CELL_HEIGHT = 36;
    protected JoinGroupList groupList;
    protected Button createGroup;
    protected int units;

    public JoinGroupScreen() {
        super(TITLE, 236, 0);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft += 2;
        this.guiTop = 32;
        int minUnits = Mth.m_14167_((float)2.2222223f);
        this.units = Math.max(minUnits, (this.f_96544_ - 16 - 32 - this.guiTop * 2) / 18);
        this.ySize = 16 + this.units * 18 + 32;
        if (this.groupList != null) {
            this.groupList.m_306878_(this.f_96543_, this.units * 18, 0, this.guiTop + 16);
        } else {
            this.groupList = new JoinGroupList(this, this.f_96543_, this.units * 18, this.guiTop + 16, 36);
        }
        this.m_7787_((GuiEventListener)this.groupList);
        this.createGroup = Button.m_253074_((Component)CREATE_GROUP, button -> this.f_96541_.m_91152_((Screen)new CreateGroupScreen())).m_252987_(this.guiLeft + 7, this.guiTop + this.ySize - 20 - 7, this.xSize - 14, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.createGroup);
    }

    @Override
    public void m_280273_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop, 0, 0, this.xSize, 16);
        for (int i = 0; i < this.units; ++i) {
            guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop + 16 + 18 * i, 0, 16, this.xSize, 18);
        }
        guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop + 16 + 18 * this.units, 0, 34, this.xSize, 32);
        guiGraphics.m_280218_(TEXTURE, this.guiLeft + 10, this.guiTop + 16 + 6 - 2, this.xSize, 0, 12, 12);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.m_280614_(this.f_96547_, JOIN_CREATE_GROUP, this.guiLeft + this.xSize / 2 - this.f_96547_.m_92852_((FormattedText)JOIN_CREATE_GROUP) / 2, this.guiTop + 5, 0x404040, false);
        if (!this.groupList.isEmpty()) {
            this.groupList.m_88315_(guiGraphics, mouseX, mouseY, delta);
        } else {
            int n = this.f_96543_ / 2;
            int n2 = this.guiTop + 16 + this.units * 18 / 2;
            Objects.requireNonNull(this.f_96547_);
            guiGraphics.m_280653_(this.f_96547_, NO_GROUPS, n, n2 - 9 / 2, -1);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        for (JoinGroupEntry entry : this.groupList.m_6702_()) {
            if (!entry.m_5953_(mouseX, mouseY)) continue;
            ClientGroup group = entry.getGroup().getGroup();
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            if (group.hasPassword()) {
                this.f_96541_.m_91152_((Screen)new EnterPasswordScreen(group));
            } else {
                NetManager.sendToServer(new JoinGroupPacket(group.getId(), null));
            }
            return true;
        }
        return false;
    }
}

