/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.gui.audiodevice.SelectMicrophoneScreen;
import de.maxhenkel.voicechat.gui.audiodevice.SelectSpeakerScreen;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumesScreen;
import de.maxhenkel.voicechat.gui.widgets.DenoiserButton;
import de.maxhenkel.voicechat.gui.widgets.EnumButton;
import de.maxhenkel.voicechat.gui.widgets.KeybindButton;
import de.maxhenkel.voicechat.gui.widgets.MicActivationButton;
import de.maxhenkel.voicechat.gui.widgets.MicAmplificationSlider;
import de.maxhenkel.voicechat.gui.widgets.MicTestButton;
import de.maxhenkel.voicechat.gui.widgets.VoiceActivationSlider;
import de.maxhenkel.voicechat.gui.widgets.VoiceSoundSlider;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.KeyEvents;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.client.speaker.AudioType;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class VoiceChatSettingsScreen
extends VoiceChatScreenBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_voicechat_settings.png");
    private static final Component TITLE = Component.m_237115_((String)"gui.voicechat.voice_chat_settings.title");
    private static final Component ASSIGN_TOOLTIP = Component.m_237115_((String)"message.voicechat.press_to_reassign_key");
    private static final Component PUSH_TO_TALK = Component.m_237115_((String)"message.voicechat.activation_type.ptt");
    private static final Component ADJUST_VOLUMES = Component.m_237115_((String)"message.voicechat.adjust_volumes");
    private static final Component SELECT_MICROPHONE = Component.m_237115_((String)"message.voicechat.select_microphone");
    private static final Component SELECT_SPEAKER = Component.m_237115_((String)"message.voicechat.select_speaker");
    private static final Component BACK = Component.m_237115_((String)"message.voicechat.back");
    @Nullable
    private final Screen parent;
    private VoiceActivationSlider voiceActivationSlider;
    private MicTestButton micTestButton;
    private KeybindButton keybindButton;

    public VoiceChatSettingsScreen(@Nullable Screen parent) {
        super(TITLE, 248, 219);
        this.parent = parent;
    }

    public VoiceChatSettingsScreen() {
        this(null);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        int y = this.guiTop + 20;
        this.m_142416_((GuiEventListener)new VoiceSoundSlider(this.guiLeft + 10, y, this.xSize - 20, 20));
        this.m_142416_((GuiEventListener)new MicAmplificationSlider(this.guiLeft + 10, y += 21, this.xSize - 20, 20));
        this.m_142416_((GuiEventListener)new DenoiserButton(this.guiLeft + 10, y += 21, this.xSize - 20, 20));
        this.voiceActivationSlider = new VoiceActivationSlider(this.guiLeft + 10 + 20 + 1, (y += 21) + 21, this.xSize - 20 - 20 - 1, 20);
        this.micTestButton = new MicTestButton(this.guiLeft + 10, y + 21, this.voiceActivationSlider);
        this.keybindButton = new KeybindButton(KeyEvents.KEY_PTT, this.guiLeft + 10 + 20 + 1, y + 21, this.xSize - 20 - 20 - 1, 20, PUSH_TO_TALK);
        this.m_142416_((GuiEventListener)new MicActivationButton(this.guiLeft + 10, y, this.xSize - 20, 20, type -> {
            this.voiceActivationSlider.f_93624_ = MicrophoneActivationType.VOICE.equals(type);
            this.keybindButton.f_93624_ = MicrophoneActivationType.PTT.equals(type);
        }));
        this.m_142416_((GuiEventListener)this.micTestButton);
        this.m_142416_((GuiEventListener)this.voiceActivationSlider);
        this.m_142416_((GuiEventListener)this.keybindButton);
        this.m_142416_((GuiEventListener)new EnumButton<AudioType>(this.guiLeft + 10, y += 42, this.xSize - 20, 20, VoicechatClient.CLIENT_CONFIG.audioType){

            @Override
            protected Component getText(AudioType type) {
                return Component.m_237110_((String)"message.voicechat.audio_type", (Object[])new Object[]{type.getText()});
            }

            @Override
            protected void onUpdate(AudioType type) {
                ClientVoicechat client = ClientManager.getClient();
                if (client != null) {
                    VoiceChatSettingsScreen.this.micTestButton.stop();
                    client.reloadAudio();
                }
            }
        });
        y += 21;
        if (this.isIngame()) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)ADJUST_VOLUMES, button -> this.f_96541_.m_91152_((Screen)new AdjustVolumesScreen())).m_252987_(this.guiLeft + 10, y, this.xSize - 20, 20).m_253136_());
            y += 21;
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)SELECT_MICROPHONE, button -> this.f_96541_.m_91152_((Screen)new SelectMicrophoneScreen(this))).m_252987_(this.guiLeft + 10, y, (this.xSize - 20) / 2 - 1, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)SELECT_SPEAKER, button -> this.f_96541_.m_91152_((Screen)new SelectSpeakerScreen(this))).m_252987_(this.guiLeft + this.xSize / 2 + 1, y, (this.xSize - 20) / 2 - 1, 20).m_253136_());
        y += 21;
        if (!this.isIngame() && this.parent != null) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)BACK, button -> this.f_96541_.m_91152_(this.parent)).m_252987_(this.guiLeft + 10, y, this.xSize - 20, 20).m_253136_());
        }
    }

    @Override
    public void m_280273_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.isIngame()) {
            guiGraphics.m_280218_(TEXTURE, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        }
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        int titleWidth = this.f_96547_.m_92852_((FormattedText)TITLE);
        guiGraphics.m_280649_(this.f_96547_, TITLE.m_7532_(), this.guiLeft + (this.xSize - titleWidth) / 2, this.guiTop + 7, this.getFontColor(), false);
        Component sliderTooltip = this.voiceActivationSlider.getHoverText();
        if (this.voiceActivationSlider.m_274382_() && sliderTooltip != null) {
            guiGraphics.m_280557_(this.f_96547_, sliderTooltip, mouseX, mouseY);
        } else if (this.keybindButton.m_274382_()) {
            guiGraphics.m_280557_(this.f_96547_, ASSIGN_TOOLTIP, mouseX, mouseY);
        }
    }

    public boolean m_6913_() {
        if (this.keybindButton.isListening()) {
            return false;
        }
        return super.m_6913_();
    }
}

