/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.init;

import com.endertech.minecraft.mods.adfinders.finder.Definitions;
import com.endertech.minecraft.mods.adfinders.finder.Ore;
import com.endertech.minecraft.mods.adfinders.init.FinderType;

public class Targets {
    static void init(String modId, Initializer initializer) {
        initializer.init(((Definitions)FinderType.GEM.definitions.get()).forMod(modId), ((Definitions)FinderType.METAL.definitions.get()).forMod(modId), ((Definitions)FinderType.MINERAL.definitions.get()).forMod(modId));
    }

    public static void initAll() {
        Targets.init("minecraft", new Vanilla());
        Targets.init("extragems", new ExtraGems());
        Targets.init("undergroundbiomes", new UndergroundBiomes());
        Targets.init("mysticalworld", new MysticalWorld());
        Targets.init("techemistry", new Techemistry());
        Targets.init("simpleores", new SimpleOres());
        Targets.init("gemsplusplus", new GemsPlusPlus());
        Targets.init("silentgems", new SilentGems());
        Targets.init("silentgear", new SilentGear());
        Targets.init("silents_mechanisms", new SilentsMechanisms());
        Targets.init("vulcanite", (gem, met, min) -> met.withPrefixes("nether").suffixOre().addOre(Ore.Metals.VULCANITE.colored(-380416)));
        Targets.init("moreoresinone", new MoreOresInONE());
        Targets.init("mmorpg", new MineAndSlash());
        Targets.init("oresabovediamonds", (gem, met, min) -> gem.withPrefixes("", "deepslate", "end", "nether").suffixOre().addOres(Ore.Gems.AMETHYST.colored(-3823877)).addOre("black_opal", Ore.Gems.OPAL.colored(-12301956)));
        Targets.init("mysticalagriculture", (gem, met, min) -> min.prefixNoneAndDeepslate().suffixOre().addOres(new Ore("prosperity", -3278086), new Ore("inferium", -7558144), new Ore("soulium", -7777221)));
        Targets.init("immersiveengineering", new ImmersiveEngineering());
        Targets.init("create", (gem, met, min) -> met.prefixNoneAndDeepslate().suffixOre().addOres(Ore.Metals.ZINC.colored(-7558253)));
        Targets.init("evilcraft", (gem, met, min) -> gem.withMetaAll().addOre("dark_ore", -16777216));
        Targets.init("appliedenergistics2", (gem, met, min) -> gem.suffixOre().addOre(Ore.Gems.QUARTZ.colored(-8543548)).addOre("charged_quartz", Ore.Gems.QUARTZ.colored(-6963731)));
        Targets.init("mapperbase", (gem, met, min) -> min.suffixOre().addOre(Ore.Minerals.BITUMEN.colored(-16777216)));
        Targets.init("quark", (gem, met, min) -> gem.suffixOre().addOre("biotite", -16514040));
        Targets.init("iceandfire", new IceAndFire());
        Targets.init("astralsorcery", new AstralSorcery());
        Targets.init("vanillafoodpantry", (gem, met, min) -> min.withSuffixes("ore", "ore_nether").addOres(Ore.Minerals.ROCK_SALT.colored(-4157042)).suffixOre().addOres(Ore.of("natron", -4995918), Ore.of("trona", -1329310)));
        Targets.init("tconstruct", (gem, met, min) -> met.suffixOre().addOres(Ore.Metals.COBALT.colored(-14976274), Ore.Metals.COPPER.colored(-8795257)));
        Targets.init("allthemodium", (gem, met, min) -> met.suffixOre().addOres(Ore.Metals.VIBRANIUM.colored(-14229880), Ore.of("unobtainium", -5755677)).withMetaAll().addOre(Ore.of("allthemodium", -14580)));
        Targets.init("omegacraft", (gem, met, min) -> met.withNoDelimiters().withPrefixes("ore_").withSuffixes("b").addOres(Ore.Metals.COPPER.colored(-4560384), Ore.Metals.TIN.colored(-4606271), Ore.Metals.LEAD.colored(-10063476), Ore.Metals.SILVER.colored(-6638148), Ore.Metals.ALUMINUM.colored(-5402465), Ore.of("magmite", -5427712)));
        Targets.init("bno", new BasicNetherOres());
        Targets.init("byg", new BiomesYouGo());
        Targets.init("gobber2", new Gobber());
        Targets.init("futurepack", new FuturePack());
        Targets.init("miningmaster", new MiningMaster());
        Targets.init("unearthed", new Unearthed());
        Targets.init("elementalcraft", (gem, met, min) -> gem.prefixNoneAndDeepslate().suffixOre().addOre("inert_crystal", -1841690));
        Targets.init("malum", (gem, met, min) -> gem.suffixOre().addOre("blazing_quartz", -1261257).withPrefixes("deepslate", "natural").addOre(Ore.Gems.QUARTZ.colored(-2435633)).prefixNoneAndDeepslate().addOre("soulstone", -8828541));
        Targets.init("mysticalagradditions", (gem, met, min) -> min.withPrefixes("nether", "end").suffixOre().addOre("prosperity", -3278086).addOre("inferium", -7558144));
        Targets.init("stalwart_dungeons", (gem, met, min) -> {
            gem.suffixOre().addOre("chorundum", -10473025);
            met.suffixOre().addOre(Ore.Metals.TUNGSTEN.colored(-6304660));
        });
        Targets.init("gemsandcrystals", (gem, met, min) -> gem.prefixNoneAndDeepslate().suffixOre().addOres(Ore.Gems.RUBY.colored(-6614754), Ore.Gems.SAPPHIRE.colored(-16770904), Ore.Gems.AMETHYST.colored(-6723892), Ore.Gems.TOPAZ.colored(-14212), Ore.Gems.QUARTZ.colored(-2578)));
        Targets.init("gemsnjewels", new GemsAndJewels());
        Targets.init("mekanism", new Mekanism());
        Targets.init("powah", (gem, met, min) -> met.prefixNoneAndDeepslate().withSuffixes("ore", "ore_poor", "ore_dense").addOres(Ore.Metals.URANINITE.colored(-12396800)));
        Targets.init("geolosys", new Geolosys());
        Targets.init("common_sense_forge", new CommonSense());
        Targets.init("blue_skies", new BlueSkies());
        Targets.init("divinerpg", new DivineRPG());
        Targets.init("oreandmore", new OreAndMore());
        Targets.init("denseores", new DenseOres());
        Targets.init("condensedores", new CondensedOres());
        Targets.init("ad_astra", new AdAstra());
    }

    static interface Initializer {
        public void init(Definitions var1, Definitions var2, Definitions var3);
    }

    static class Vanilla
    implements Initializer {
        Vanilla() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            String[] prefixes = new String[]{"", "deepslate"};
            gems.withPrefixes(prefixes).suffixOre().addOres(Ore.Gems.DIAMOND.colored(-12721947), Ore.Gems.EMERALD.colored(-16209361), Ore.Gems.LAPIS.colored(-16776961)).addOre("nether_quartz", Ore.Gems.QUARTZ.colored(-790298));
            metals.addOre("ancient_debris", -8626601).withPrefixes(prefixes).suffixOre().addOres(Ore.Metals.IRON.colored(-2180985), Ore.Metals.COPPER.colored(-3840700), Ore.Metals.GOLD.colored(-10496)).addOre("nether_gold", Ore.Metals.GOLD.colored(-10496)).withPrefixes("raw").withSuffixes("block").addOres(Ore.Metals.IRON.colored(-2180985), Ore.Metals.COPPER.colored(-3840700), Ore.Metals.GOLD.colored(-10496));
            minerals.withPrefixes(prefixes).suffixOre().addOres(Ore.COAL).withMetaAll().addOre(Ore.Minerals.REDSTONE.colored(-65536));
        }
    }

    static class ExtraGems
    implements Initializer {
        ExtraGems() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.suffixOre().addOres(Ore.Gems.RUBY.colored(-2549987), Ore.Gems.SAPPHIRE.colored(-15252007), Ore.Gems.AMETHYST.colored(-6875175), Ore.Gems.TOPAZ.colored(-2510825), Ore.Gems.CRYSTAL.colored(-7810327));
        }
    }

    static class UndergroundBiomes
    implements Initializer {
        UndergroundBiomes() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            String ore = "ore_minecraft";
            String[] prefixes = Definitions.Prefixes.create().add("igneous", ore).add("metamorphic", ore).add("sedimentary", ore).toArray();
            ore = "ore";
            String[] suffixes = Definitions.Suffixes.create().add(ore, "andesite").add(ore, "basalt").add(ore, "black_granite").add(ore, "blueschist").add(ore, "chalk").add(ore, "chert").add(ore, "dacite").add(ore, "dolomite").add(ore, "eclogite").add(ore, "gabbro").add(ore, "gneiss").add(ore, "granite").add(ore, "greenschist").add(ore, "greywacke").add(ore, "komatiite").add(ore, "lignite").add(ore, "limestone").add(ore, "marble").add(ore, "migmatite").add(ore, "quartzite").add(ore, "red_granite").add(ore, "rhyolite").add(ore, "shale").add(ore, "siltstone").add(ore, "soapstone").toArray();
            gems.withPrefixes(prefixes).withSuffixes(suffixes).withMetaAll().addOres(Ore.Gems.DIAMOND.colored(-11866671), Ore.Gems.EMERALD.colored(-16732104), Ore.Gems.LAPIS.colored(-16776961));
            metals.withPrefixes(prefixes).withSuffixes(suffixes).withMetaAll().addOres(Ore.Metals.GOLD.colored(-10496), Ore.Metals.IRON.colored(-2180985));
            minerals.withPrefixes(prefixes).withSuffixes(suffixes).withMetaAll().addOres(Ore.COAL, Ore.Minerals.REDSTONE.colored(-65536));
        }
    }

    static class MysticalWorld
    implements Initializer {
        MysticalWorld() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.suffixOre().addOres(Ore.Gems.AMETHYST.colored(-2776838));
            metals.suffixOre().addOres(Ore.Metals.COPPER.colored(-953046), Ore.Metals.LEAD.colored(-13355709), Ore.Metals.SILVER.colored(-6375738), Ore.Metals.TIN.colored(-7165290)).addOre("quicksilver", Ore.Metals.SILVER.colored(-7627102));
        }
    }

    static class Techemistry
    implements Initializer {
        Techemistry() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            minerals.suffixOre().addOres(Ore.Minerals.CARBONATE.colored(-1252946), Ore.Minerals.PHOSPHATE.colored(-9836645), Ore.Minerals.SULFUR.colored(-200960), Ore.Minerals.OXIDE.colored(-4079167), Ore.Minerals.SULFATE.colored(-4730698));
        }
    }

    static class SimpleOres
    implements Initializer {
        SimpleOres() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.suffixOre().addOre(Ore.Gems.ONYX.colored(-15132391));
            metals.prefixNoneAndDeepslate().suffixOre().addOres(Ore.Metals.TIN.colored(-8158320), Ore.Metals.MYTHRIL.colored(-9013523), Ore.Metals.ADAMANTIUM.colored(-13863354));
        }
    }

    static class GemsPlusPlus
    implements Initializer {
        GemsPlusPlus() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.withNoDelimiters().withPrefixes("ore", "netherore").addOres(Ore.Gems.RUBY.colored(-3533788), Ore.Gems.SAPPHIRE.colored(-16768648), Ore.Gems.AMETHYST.colored(-13631368), Ore.Gems.TOPAZ.colored(-10662641), new Ore("phoenixite", -766720), Ore.Gems.JADE.colored(-10434028), Ore.Gems.CITRINE.colored(-3495404), Ore.Gems.GARNET.colored(-6025187), Ore.Gems.SPINEL.colored(-3533722), Ore.Gems.ONYX.colored(-15987700), Ore.Gems.AGATE.colored(-15435318), Ore.Gems.MALACHITE.colored(-15414702), Ore.Gems.TOURMALINE.colored(-3533676), Ore.Gems.CHRYSOCOLLA.colored(-15414599), Ore.Gems.JASPER.colored(-5362120), Ore.Gems.SUGILITE.colored(-11796258));
        }
    }

    static class SilentGems
    implements Initializer {
        SilentGems() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.withSuffixes("classic", "dark", "light").addOre(new Ore("multi_ore", -1));
            gems.suffixOre().addOres(new Ore("chaos", -5004387), new Ore("ender", -11476799), new Ore("cats_eye", -342978)).addOre("green_sapphire", Ore.Gems.SAPPHIRE.colored(-15214305)).addOre("black_diamond", -16777216).addOre("yellow_diamond", -918978).addOre("white_diamond", -1).addOre("rose_quartz", Ore.Gems.QUARTZ.colored(-1481064));
            gems.suffixOre().addOres(Ore.Gems.PHOSPHOPHYLLITE.colored(-15214208), Ore.Gems.CARNELIAN.colored(-4517376), Ore.Gems.MORGANITE.colored(-371764), Ore.Gems.SPINEL.colored(-4501504), Ore.Gems.CITRINE.colored(-4493568), Ore.Gems.JASPER.colored(-4481536), Ore.Gems.ZIRCON.colored(-4605184), Ore.Gems.MOLDAVITE.colored(-6636800), Ore.Gems.MALACHITE.colored(-16729279), Ore.Gems.TURQUOISE.colored(-16729186), Ore.Gems.EUCLASE.colored(-16745541), Ore.Gems.BENITOITE.colored(-16769605), Ore.Gems.ALEXANDRITE.colored(-5439301), Ore.Gems.LEPIDOLITE.colored(-4521846), Ore.Gems.AMETRINE.colored(-4521893), Ore.Gems.MOONSTONE.colored(-10395295), Ore.Gems.MALACHITE.colored(-16729279), Ore.Gems.PYROPE.colored(-377244), Ore.Gems.CORAL.colored(-371138), Ore.Gems.SUNSTONE.colored(-362946), Ore.Gems.JADE.colored(-7079362), Ore.Gems.CHRYSOPRASE.colored(-11208130), Ore.Gems.APATITE.colored(-12649772), Ore.Gems.FLUORITE.colored(-12664070), Ore.Gems.KYANITE.colored(-13014299), Ore.Gems.SODALITE.colored(-11453718), Ore.Gems.AMMOLITE.colored(-3787046), Ore.Gems.KUNZITE.colored(-2541898), Ore.Gems.TEKTITE.colored(-9412268), Ore.Gems.PEARL.colored(-7496010), Ore.Gems.RUBY.colored(-2547945), Ore.Gems.GARNET.colored(-2535401), Ore.Gems.TOPAZ.colored(-2526953), Ore.Gems.AMBER.colored(-2514665), Ore.Gems.HELIODOR.colored(-2506473), Ore.Gems.PERIDOT.colored(-7349993), Ore.Gems.BERYL.colored(-15214305), Ore.Gems.INDICOLITE.colored(-15214208), Ore.Gems.AQUAMARINE.colored(-15232598), Ore.Gems.SAPPHIRE.colored(-14871077), Ore.Gems.IOLITE.colored(-10479655), Ore.Gems.AMETHYST.colored(-6088741), Ore.Gems.AGATE.colored(-2549808), Ore.Gems.ONYX.colored(-16777216), Ore.Gems.OPAL.colored(-4737097));
            metals.withPrefixes("", "deepslate").suffixOre().addOres(Ore.Metals.SILVER.colored(-2829100));
        }
    }

    static class SilentGear
    implements Initializer {
        SilentGear() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            metals.suffixOre().addOre("crimson_iron", -2927504).addOre("azure_silver", -1597204);
            minerals.prefixNoneAndDeepslate().suffixOre().addOre("bort", -5193255);
        }
    }

    static class SilentsMechanisms
    implements Initializer {
        SilentsMechanisms() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            metals.suffixOre().addOres(Ore.Metals.ZINC.colored(-11113380), Ore.Metals.TIN.colored(-7953744), Ore.Metals.NICKEL.colored(-1843297), Ore.Metals.COPPER.colored(-492214), Ore.Metals.BAUXITE.colored(-1726794), Ore.Metals.LEAD.colored(-6385992), Ore.Metals.URANIUM.colored(-7285618), Ore.Metals.PLATINUM.colored(-6832194), Ore.Metals.BISMUTH.colored(-3754036), Ore.Metals.SILVER.colored(-6838593));
        }
    }

    static class MoreOresInONE
    implements Initializer {
        MoreOresInONE() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.suffixOre().addOres(Ore.Gems.RUBY.colored(-3996641), Ore.Gems.AMETHYST.colored(-7927400), Ore.Gems.SAPPHIRE.colored(-11199024), Ore.Gems.TOPAZ.colored(-354544));
            gems.withPrefixes("overworld", "end", "nether").suffixOre().addOre("exp", -16716752);
        }
    }

    static class MineAndSlash
    implements Initializer {
        MineAndSlash() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.prefixOre().addOre("block0", new Ore("common ore", -10782866)).addOre("block1", new Ore("uncommon ore", -15214240)).addOre("block2", new Ore("rare ore", -3614441)).addOre("block3", new Ore("epic ore", -15226919)).addOre("block4", new Ore("legendary ore", -2512361)).addOre("block5", new Ore("mythical ore", -2287709));
        }
    }

    static class ImmersiveEngineering
    implements Initializer {
        ImmersiveEngineering() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            metals.withPrefixes("ore", "deepslate_ore").addOres(Ore.Metals.COPPER.colored(-11371417), Ore.Metals.ALUMINUM.colored(-8232882), Ore.Metals.LEAD.colored(-12634036), Ore.Metals.SILVER.colored(-4142900), Ore.Metals.NICKEL.colored(-6709351), Ore.Metals.URANIUM.colored(-11243448));
        }
    }

    static class IceAndFire
    implements Initializer {
        IceAndFire() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.suffixOre().addOre("amythest", Ore.Gems.AMETHYST.colored(-4440321)).addOres(Ore.Gems.SAPPHIRE.colored(-15178256));
            metals.suffixOre().addOres(Ore.Metals.COPPER.colored(-3233161), Ore.Metals.SILVER.colored(-1708809));
        }
    }

    static class AstralSorcery
    implements Initializer {
        AstralSorcery() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.suffixOre().addOre("aquamarine_sand", Ore.Gems.AQUAMARINE.colored(-12913665)).addOre("rock_crystal", -1);
            metals.suffixOre().addOre("starmetal", -16772262);
        }
    }

    static class BasicNetherOres
    implements Initializer {
        BasicNetherOres() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            String nether = "nether";
            metals.withPrefixes("nether").suffixOre().addOres(Ore.Metals.SILVER.colored(-2829100), Ore.Metals.IRON.colored(-2839664), Ore.Metals.LEAD.colored(-7958373), Ore.Metals.NICKEL.colored(-5263210), Ore.Metals.COPPER.colored(-2067635), Ore.Metals.ALUMINUM.colored(-8092509), Ore.Metals.TIN.colored(-4473925), Ore.Metals.OSMIUM.colored(-2960653), Ore.Metals.ZINC.colored(-6899554), Ore.Metals.URANIUM.colored(-7421301));
            gems.withPrefixes("nether").suffixOre().addOres(Ore.Gems.EMERALD.colored(-15214240), Ore.Gems.DIAMOND.colored(-12788512), Ore.Gems.LAPIS.colored(-15711319));
            minerals.withPrefixes("nether").suffixOre().addOres(Ore.Minerals.REDSTONE.colored(-3537145), Ore.COAL.colored(-12698050));
        }
    }

    static class BiomesYouGo
    implements Initializer {
        BiomesYouGo() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.suffixOre().addOres(Ore.Gems.AMETRINE.colored(-3707734), Ore.Gems.EMERALDITE.colored(-16209361)).addOre("budding_ametrine", Ore.Gems.AMETRINE.colored(-3707734)).addOre("brimstone_nether_quartz", Ore.Gems.QUARTZ.colored(-790298));
            metals.suffixOre().addOre("pendorite", -11264943).addOre("blue_nether_gold", Ore.Metals.GOLD.colored(-10496)).addOre("brimstone_nether_gold", Ore.Metals.GOLD.colored(-10496));
            minerals.addOre("pervaded_netherrack", Ore.of("netherrack", -989321));
            minerals.suffixOre().addOres(Ore.ANTHRACITE.colored(-15854821), Ore.LIGNITE.colored(-11189967)).addOre("cryptic_redstone", Ore.Minerals.REDSTONE.colored(-5766140));
        }
    }

    static class Gobber
    implements Initializer {
        Gobber() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            String prefix = "gobber2";
            metals.withPrefixes("gobber2").addOre("ore", -11301691).addOre("ore_nether", -5424279).addOre("ore_end", -14304610);
            gems.withPrefixes("gobber2").addOre("lucky_block", -11301690);
        }
    }

    static class FuturePack
    implements Initializer {
        FuturePack() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            minerals.prefixOre().addOre("coal_m", Ore.COAL.colored(-13421773));
            metals.prefixOre().addOres(Ore.Metals.BAUXITE.colored(-3716864), Ore.Metals.COPPER.colored(-1735856), Ore.Metals.TIN.colored(-3487030), Ore.Metals.ZINC.colored(-7159812), Ore.Metals.MAGNETITE.colored(-8095694)).addOre("copper_m", Ore.Metals.COPPER.colored(-1932979));
            gems.prefixOre().addOre("quartz_m", Ore.Gems.QUARTZ.colored(-2764083));
        }
    }

    static class MiningMaster
    implements Initializer {
        MiningMaster() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.suffixOre().addOre("fire_ruby", Ore.Gems.RUBY.colored(-4123608)).addOre("ice_sapphire", Ore.Gems.SAPPHIRE.colored(-15582521)).addOre("spirit_garnet", Ore.Gems.GARNET.colored(-10873545)).addOre("haste_peridot", Ore.Gems.PERIDOT.colored(-6703838)).addOre("lucky_citrine", Ore.Gems.CITRINE.colored(-2531575)).addOre("dive_aquamarine", Ore.Gems.AQUAMARINE.colored(-13075541)).addOre("heart_rhodonite", Ore.Gems.RHODONITE.colored(-365942)).addOre("power_pyrite", Ore.Gems.PYRITE.colored(-6060731)).addOre("kinetic_opal", Ore.Gems.OPAL.colored(-810431)).addOre("air_malachite", Ore.Gems.MALACHITE.colored(-16729189));
        }
    }

    static class Unearthed
    implements Initializer {
        Unearthed() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            String[] prefixes = new String[]{"slate", "gabbro", "conglomerate", "granodiorite", "white_granite", "rhyolite", "phyllite", "beige_limestone", "limestone", "grey_limestone", "siltstone", "mudstone", "sandstone"};
            gems.withPrefixes(prefixes).suffixOre().addOres(Ore.Gems.DIAMOND.colored(-12721947), Ore.Gems.EMERALD.colored(-16209361), Ore.Gems.LAPIS.colored(-16776961));
            metals.withPrefixes(prefixes).suffixOre().addOres(Ore.Metals.IRON.colored(-2180985), Ore.Metals.COPPER.colored(-3840700), Ore.Metals.GOLD.colored(-10496));
            minerals.withPrefixes(prefixes).suffixOre().addOres(Ore.COAL).withMetaAll().addOre(Ore.Minerals.REDSTONE.colored(-65536));
        }
    }

    static class GemsAndJewels
    implements Initializer {
        GemsAndJewels() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            String[] suffixes = new String[]{"ore_block", "deepslate_ore_block", "nether_ore_block"};
            gems.withSuffixes(suffixes).addOres(Ore.of("pale_diamond", -5384466), Ore.Gems.DIAMOND.colored(-12987946), Ore.Gems.EMERALD.colored(-16724354), Ore.Gems.RUBY.colored(-3271373), Ore.Gems.SAPPHIRE.colored(-16765773), Ore.Gems.AMETHYST.colored(-4689942), Ore.Gems.OPAL.colored(-2039584), Ore.Gems.GARNET.colored(-11202784), Ore.Gems.TOPAZ.colored(-2449589), Ore.Gems.PERIDOT.colored(-5905065), Ore.Gems.AQUAMARINE.colored(-12398376), Ore.Gems.ZIRCON.colored(-14392603), Ore.Gems.ALEXANDRITE.colored(-10349106), Ore.Gems.TANZANITE.colored(-8245052), Ore.Gems.TOURMALINE.colored(-4187031), Ore.Gems.SPINEL.colored(-1747080), Ore.of("black_opal", -16699586), Ore.Gems.CITRINE.colored(-1139661), Ore.Gems.MORGANITE.colored(-1148811), Ore.Gems.AMETRINE.colored(-7000096), Ore.Gems.KUNZITE.colored(-1747011), Ore.Gems.IOLITE.colored(-10747700), Ore.of("bright_opal", -1118482));
        }
    }

    static class Mekanism
    implements Initializer {
        Mekanism() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            metals.prefixNoneAndDeepslate().suffixOre().addOres(Ore.Metals.TIN.colored(-2434342), Ore.Metals.OSMIUM.colored(-5654583), Ore.Metals.URANIUM.colored(-11945910), Ore.Metals.LEAD.colored(-11841441));
            gems.prefixNoneAndDeepslate().suffixOre().addOres(Ore.Gems.FLUORITE.colored(-2317607));
        }
    }

    static class Geolosys
    implements Initializer {
        Geolosys() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.prefixNoneAndDeepslate().suffixOre().addOres(Ore.Gems.QUARTZ.colored(-5325604), Ore.Gems.MALACHITE.colored(-12805263), Ore.Gems.AZURITE.colored(-14336402), Ore.Gems.BERYL.colored(-16713053), Ore.Gems.KIMBERLITE.colored(-9447485), Ore.Gems.LAPIS.colored(-16776961));
            metals.suffixOre().addOre(Ore.Metals.ANCIENT_DEBRIS.colored(-11917283)).addOre("nether_gold", Ore.Metals.GOLD.colored(-3102682)).prefixNoneAndDeepslate().addOres(Ore.Metals.AUTUNITE.colored(-4596720), Ore.Metals.SPHALERITE.colored(-11977378), Ore.Metals.TEALLITE.colored(-4611696), Ore.Metals.BAUXITE.colored(-5409458), Ore.Metals.GALENA.colored(-11514018), Ore.Metals.HEMATITE.colored(-9884132), Ore.Metals.CASSITERITE.colored(-2962779), Ore.Metals.CINNABAR.colored(-7661044), Ore.Metals.GOLD.colored(-10496), Ore.Metals.PLATINUM.colored(-8091235), Ore.Metals.LIMONITE.colored(-4022950));
            minerals.prefixNoneAndDeepslate().suffixOre().addOre("anthracite_coal", Ore.COAL).addOre(Ore.COAL).addOre("bituminous_coal", Ore.COAL.colored(-14212833)).addOre("lignite", Ore.COAL.colored(-14212833));
        }
    }

    static class CommonSense
    implements Initializer {
        CommonSense() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            String[] stoneTypes = new String[]{"andesite", "diorite", "granite"};
            gems.suffixOre().withPrefixes("", "deep_slate").addOres(Ore.Gems.AMBER.colored(-1199616)).withPrefixes(stoneTypes).addOres(Ore.Gems.DIAMOND.colored(-12721947), Ore.Gems.EMERALD.colored(-16209361), Ore.Gems.LAPIS.colored(-16776961));
            metals.suffixOre().addOres(Ore.of("ancient", -10588061), Ore.of("prabalit", -10588061), Ore.of("netherack_iron", -2903395)).withPrefixes(stoneTypes).addOres(Ore.Metals.IRON.colored(-2180985), Ore.Metals.COPPER.colored(-3840700), Ore.Metals.GOLD.colored(-10496));
            minerals.addOre("rock_salt", -1188418).suffixOre().addOre("end_fragment", -2299991).withPrefixes("", "deepslate").addOres(Ore.Minerals.NITER.colored(-7434752)).withPrefixes("", "deep_slate").addOres(Ore.Minerals.SULFUR.colored(-4276736)).withPrefixes(stoneTypes).addOres(Ore.COAL).withMetaAll().addOre(Ore.Minerals.REDSTONE.colored(-65536));
        }
    }

    static class BlueSkies
    implements Initializer {
        BlueSkies() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            gems.withPrefixes("everbright", "everdawn").suffixOre().addOres(Ore.Gems.EMERALD.colored(-12721541), Ore.Gems.MOONSTONE.colored(-7092257), Ore.Gems.PYROPE.colored(-3400145), Ore.of("aquite", -11163693), Ore.of("diopside", -16723945), Ore.of("charoite", -5603126));
            metals.suffixOre().addOre("falsite", -10602330).addOre("ventium", -3328972).addOre("horizonite", -1211082);
        }
    }

    static class DivineRPG
    implements Initializer {
        DivineRPG() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            metals.withSuffixes("ore", "ore_deepslate").addOre("arlemite", -13068766).addOre("realmite", -4762108).addOre("rupee", -14456414).suffixOre().addOre("torridite", -5097172);
            gems.suffixOre().addOre("bloodgem", -3982478).addOre("eden", -1).addOre("wildwood", -13404736).addOre("apalachia", -2003997).addOre("skythern", -4210482).addOre("mortum", -11120046);
        }
    }

    static class OreAndMore
    implements Initializer {
        OreAndMore() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            metals.addOre("demoniteore", Ore.of("demonite", -3537916)).addOre("auric_ore", Ore.of("auric", -4619447));
            gems.addOre("rubyore", Ore.Gems.RUBY.colored(-7266271)).addOre("deepslatediamondore", Ore.Gems.DIAMOND.colored(-6348252)).addOre("rose_quartz_ore", Ore.Gems.QUARTZ.colored(-1875081)).addOre("fire_embers_ore", Ore.of("fire_embers", -4164045));
        }
    }

    static class DenseOres
    implements Initializer {
        DenseOres() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            String[] prefixes = new String[]{"dense", "dense_deepslate"};
            gems.withPrefixes(prefixes).suffixOre().addOres(Ore.Gems.DIAMOND.colored(-12721947), Ore.Gems.EMERALD.colored(-16209361), Ore.Gems.LAPIS.colored(-16776961)).addOre("nether_quartz", Ore.Gems.QUARTZ.colored(-790298));
            metals.addOre("ancient_nether_ore", Ore.Metals.ANCIENT_DEBRIS.colored(-8626601)).withPrefixes(prefixes).suffixOre().addOres(Ore.Metals.IRON.colored(-2180985), Ore.Metals.COPPER.colored(-3840700), Ore.Metals.GOLD.colored(-10496)).addOre("nether_gold", Ore.Metals.GOLD.colored(-10496));
            minerals.withPrefixes(prefixes).suffixOre().addOres(Ore.COAL).withMetaAll().addOre(Ore.Minerals.REDSTONE.colored(-65536));
        }
    }

    static class CondensedOres
    implements Initializer {
        CondensedOres() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            String[] prefixes = new String[]{"dense"};
            gems.withPrefixes(prefixes).suffixOre().addOres(Ore.Gems.DIAMOND.colored(-12721947), Ore.Gems.EMERALD.colored(-16209361), Ore.Gems.LAPIS.colored(-16776961)).addOre("nether_quartz", Ore.Gems.QUARTZ.colored(-790298));
            metals.addOre("dense_debris", Ore.Metals.ANCIENT_DEBRIS.colored(-8626601)).withPrefixes(prefixes).suffixOre().addOres(Ore.Metals.IRON.colored(-2180985), Ore.Metals.COPPER.colored(-3840700), Ore.Metals.GOLD.colored(-10496)).addOre("nether_gold", Ore.Metals.GOLD.colored(-10496));
            minerals.withPrefixes(prefixes).suffixOre().addOres(Ore.COAL).withMetaAll().addOre(Ore.Minerals.REDSTONE.colored(-65536));
        }
    }

    static class AdAstra
    implements Initializer {
        AdAstra() {
        }

        @Override
        public void init(Definitions gems, Definitions metals, Definitions minerals) {
            minerals.suffixOre().addOre("moon_cheese", -1197534).withPrefixes("venus", "glacio").addOre(Ore.COAL.colored(-14540254));
            metals.suffixOre().withPrefixes("moon", "deepslate").addOre("desh", -4234951).withPrefixes("moon", "mars", "glacio", "mercury").addOre(Ore.Metals.IRON.colored(-3562615)).withPrefixes("mars", "deepslate").addOre("ostrum", -8821403).withPrefixes("glacio").addOre(Ore.Metals.COPPER.colored(-3052728)).withPrefixes("venus").addOre(Ore.Metals.GOLD.colored(-1319354)).withPrefixes("venus", "deepslate").addOre("calorite", -8514508);
            gems.suffixOre().withPrefixes("moon", "mars", "glacio", "deepslate").addOre("ice_shard", -8677164).withPrefixes("mars", "venus").addOre(Ore.Gems.DIAMOND.colored(-14892345)).withPrefixes("glacio").addOre(Ore.Gems.LAPIS.colored(-15315024));
        }
    }
}

