/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.google.common.collect.Sets;
import com.supermartijn642.fusion.extensions.PackResourcesExtension;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FilePackResources.class})
public class FilePackResourcesMixin
implements PackResourcesExtension {
    @Final
    @Shadow
    private static Logger f_215322_;
    @Unique
    private String overridesFolder;
    @Final
    @Shadow
    private FilePackResources.SharedZipFileAccess f_291183_;

    @Override
    public void setFusionOverridesFolder(@NotNull String folder) {
        this.overridesFolder = folder;
    }

    @Shadow
    private String m_292954_(String string) {
        throw new AssertionError();
    }

    @Inject(method={"getResource(Ljava/lang/String;)Lnet/minecraft/server/packs/resources/IoSupplier;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getResource(String path, CallbackInfoReturnable<IoSupplier<InputStream>> ci) {
        ZipEntry zipEntry;
        if (this.overridesFolder == null) {
            return;
        }
        path = this.overridesFolder + (String)path;
        ZipFile zipFile = this.f_291183_.m_295521_();
        if (zipFile != null && (zipEntry = zipFile.getEntry(this.m_292954_((String)path))) != null) {
            ci.setReturnValue((Object)IoSupplier.m_247178_((ZipFile)zipFile, (ZipEntry)zipEntry));
        }
    }

    @Inject(method={"getNamespaces"}, at={@At(value="RETURN")}, cancellable=true)
    private void getNamespaces(PackType type, CallbackInfoReturnable<Set<String>> ci) {
        if (this.overridesFolder == null) {
            return;
        }
        ZipFile zipFile = this.f_291183_.m_295521_();
        if (zipFile == null) {
            return;
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        HashSet namespaces = Sets.newHashSet((Iterable)((Iterable)ci.getReturnValue()));
        String typePath = this.m_292954_(this.overridesFolder + type.m_10305_() + "/");
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String name = zipEntry.getName();
            String namespace = FilePackResources.m_293189_((String)typePath, (String)name);
            if (namespace.isEmpty()) continue;
            if (ResourceLocation.m_135843_((String)namespace)) {
                namespaces.add(namespace);
                continue;
            }
            f_215322_.warn("Non [a-z0-9_.-] character in namespace {} in pack {}, ignoring", (Object)namespace, (Object)this.f_291183_.f_291821_);
        }
        ci.setReturnValue((Object)namespaces);
    }

    @ModifyVariable(method={"listResources"}, at=@At(value="HEAD"), ordinal=0)
    private PackResources.ResourceOutput modifyListResources(PackResources.ResourceOutput output, PackType type, String namespace, String path) {
        if (this.overridesFolder == null) {
            return output;
        }
        ZipFile zipFile = this.f_291183_.m_295521_();
        if (zipFile == null) {
            return output;
        }
        HashSet<ResourceLocation> overriddenLocations = new HashSet<ResourceLocation>();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        String namespaceDirectory = this.m_292954_(this.overridesFolder + type.m_10305_() + "/" + namespace + "/");
        String pathDirectory = namespaceDirectory + path + "/";
        while (enumeration.hasMoreElements()) {
            String name;
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !(name = zipEntry.getName()).startsWith(pathDirectory)) continue;
            String identifier = name.substring(namespaceDirectory.length());
            ResourceLocation location2 = ResourceLocation.m_214293_((String)namespace, (String)identifier);
            if (location2 != null) {
                overriddenLocations.add(location2);
                output.accept((Object)location2, (Object)IoSupplier.m_247178_((ZipFile)zipFile, (ZipEntry)zipEntry));
                continue;
            }
            f_215322_.warn("Invalid path in datapack: {}:{}, ignoring", (Object)namespace, (Object)identifier);
        }
        return (location, streamSupplier) -> {
            if (!overriddenLocations.contains(location)) {
                output.accept(location, streamSupplier);
            }
        };
    }
}

