/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.mixin.client;

import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EditBox.class})
abstract class EditBoxMixin
extends AbstractWidget {
    @Shadow
    @Final
    public Font f_94092_;
    @Shadow
    public String f_94093_;
    @Shadow
    public boolean f_94096_;
    @Shadow
    public int f_94100_;
    @Shadow
    public int f_94101_;
    @Shadow
    public int f_94102_;
    protected long lastClickTime;
    protected boolean doubleClick;
    protected int doubleClickHighlightPos;
    protected int doubleClickCursorPos;

    public EditBoxMixin(int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
    }

    @Inject(method={"deleteText(I)V"}, at={@At(value="HEAD")}, cancellable=true)
    protected void deleteText(int charCount, CallbackInfo callback) {
        if (Screen.m_96637_()) {
            if (charCount < 0) {
                this.m_94180_(-this.f_94101_);
            }
        } else if (Screen.m_96639_()) {
            this.m_94176_(charCount);
        } else {
            this.m_94180_(charCount);
        }
        callback.cancel();
    }

    @Shadow
    public abstract void m_94176_(int var1);

    @Shadow
    public abstract void m_94180_(int var1);

    @Shadow
    public abstract int m_94184_(int var1);

    @Shadow
    protected abstract int m_94140_(int var1, int var2, boolean var3);

    @Inject(method={"getWordPosition(IIZ)I"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getWordPosition(int numWords, int pos, boolean skipConsecutiveSpaces, CallbackInfoReturnable<Integer> callback) {
        int i = pos;
        boolean backwards = numWords < 0;
        int skippedWords = Math.abs(numWords);
        for (int k = 0; k < skippedWords; ++k) {
            if (!backwards) {
                int l = this.f_94093_.length();
                while (skipConsecutiveSpaces && i == pos && i < l && !EditBoxMixin.isWordChar(this.f_94093_.charAt(i))) {
                    ++i;
                    ++pos;
                }
                while (i < l && EditBoxMixin.isWordChar(this.f_94093_.charAt(i))) {
                    ++i;
                }
                continue;
            }
            while (skipConsecutiveSpaces && i == pos && i > 0 && !EditBoxMixin.isWordChar(this.f_94093_.charAt(i - 1))) {
                --i;
                --pos;
            }
            while (i > 0 && EditBoxMixin.isWordChar(this.f_94093_.charAt(i - 1))) {
                --i;
            }
        }
        callback.setReturnValue((Object)i);
    }

    @Unique
    private static boolean isWordChar(char charAt) {
        return charAt == '_' || Character.isAlphabetic(charAt) || Character.isDigit(charAt);
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    public void keyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> callback) {
        if (this.m_142518_() && this.m_93696_()) {
            if (keyCode == 262) {
                boolean allowedToMoveRight = true;
                if (!Screen.m_96638_() && this.f_94102_ != this.f_94101_) {
                    this.m_94196_(Math.max(this.m_94207_(), this.f_94102_));
                    this.m_94208_(this.m_94207_());
                    allowedToMoveRight = false;
                }
                if (Screen.m_96637_()) {
                    this.m_94201_(Screen.m_96638_());
                } else if (Screen.m_96639_()) {
                    this.m_94192_(this.m_94184_(1), Screen.m_96638_());
                } else if (allowedToMoveRight) {
                    this.m_94188_(1, Screen.m_96638_());
                }
                callback.setReturnValue((Object)true);
            } else if (keyCode == 263) {
                boolean allowedToMoveLeft = true;
                if (!Screen.m_96638_() && this.f_94102_ != this.f_94101_) {
                    this.m_94196_(Math.min(this.m_94207_(), this.f_94102_));
                    this.m_94208_(this.m_94207_());
                    allowedToMoveLeft = false;
                }
                if (Screen.m_96637_()) {
                    this.m_94198_(Screen.m_96638_());
                } else if (Screen.m_96639_()) {
                    this.m_94192_(this.m_94184_(-1), Screen.m_96638_());
                } else if (allowedToMoveLeft) {
                    this.m_94188_(-1, Screen.m_96638_());
                }
                callback.setReturnValue((Object)true);
            }
        }
    }

    @Shadow
    public abstract void m_94188_(int var1, boolean var2);

    @Shadow
    public abstract void m_94192_(int var1, boolean var2);

    @Shadow
    public abstract void m_94196_(int var1);

    @Shadow
    public abstract void m_94198_(boolean var1);

    @Shadow
    public abstract void m_94201_(boolean var1);

    @Shadow
    public abstract int m_94207_();

    @Shadow
    public abstract int m_94210_();

    @Shadow
    public abstract void m_94208_(int var1);

    @Inject(method={"onClick"}, at={@At(value="TAIL")})
    public void onClick(double mouseX, double mouseY, CallbackInfo callback) {
        long millis = Util.m_137550_();
        boolean tripleClick = this.doubleClick;
        boolean bl = this.doubleClick = millis - this.lastClickTime < 250L;
        if (this.doubleClick) {
            if (tripleClick) {
                this.m_94201_(false);
                this.m_94208_(0);
            } else {
                this.doubleClickHighlightPos = this.m_94140_(1, this.m_94207_(), false);
                this.m_94192_(this.doubleClickHighlightPos, false);
                this.doubleClickCursorPos = this.m_94140_(-1, this.m_94207_(), false);
                this.m_94192_(this.doubleClickCursorPos, true);
            }
        }
        this.lastClickTime = millis;
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        int i = Mth.m_14107_((double)mouseX) - this.m_252754_();
        if (this.f_94096_) {
            i -= 4;
        }
        String string = this.f_94092_.m_92834_(this.f_94093_.substring(this.f_94100_), this.m_94210_());
        int mousePosition = this.f_94092_.m_92834_(string, i).length() + this.f_94100_;
        if (this.doubleClick) {
            if (this.m_93680_(mouseX, mouseY)) {
                int rightBoundary = this.m_94140_(1, mousePosition, false);
                this.m_94192_(Math.max(this.doubleClickHighlightPos, rightBoundary), false);
                int leftBoundary = this.m_94140_(-1, mousePosition, false);
                this.m_94192_(Math.min(this.doubleClickCursorPos, leftBoundary), true);
            } else {
                if (mousePosition > this.doubleClickHighlightPos) {
                    this.m_94201_(false);
                } else {
                    this.m_94192_(this.doubleClickHighlightPos, false);
                }
                if (mousePosition < this.doubleClickCursorPos) {
                    this.m_94198_(true);
                } else {
                    this.m_94192_(this.doubleClickCursorPos, true);
                }
            }
        } else if (this.m_93680_(mouseX, mouseY)) {
            this.m_94192_(mousePosition, true);
        } else if (this.f_94102_ < mousePosition) {
            this.m_94201_(true);
        } else {
            this.m_94198_(true);
        }
    }
}

