/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.init;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.Nullable;

public final class LazyHolder<T>
extends Holder.Reference<T> {
    @Nullable
    private Supplier<Holder<T>> supplier;
    private Holder<T> holder;

    public LazyHolder(ResourceKey<? extends Registry<? super T>> registryKey, Holder<T> holder) {
        this(registryKey, (ResourceKey)holder.m_203543_().orElseThrow(), () -> holder);
    }

    public LazyHolder(final ResourceKey<? extends Registry<? super T>> registryKey, ResourceKey<T> key, Supplier<Holder<T>> supplier) {
        super(Holder.Reference.Type.STAND_ALONE, new HolderOwner<T>(){

            public String toString() {
                return registryKey.toString();
            }
        }, key, null);
        Objects.requireNonNull(registryKey, "registry key is null");
        Objects.requireNonNull(key, "key is null");
        Objects.requireNonNull(supplier, "supplier is null");
        this.supplier = supplier;
    }

    private void bindHolder(boolean failIfNull) {
        if (this.supplier != null) {
            Holder<T> holder = this.supplier.get();
            if (holder != null) {
                this.holder = holder;
                super.m_247654_(this.holder.m_203334_());
                this.supplier = null;
            } else if (failIfNull) {
                throw new NullPointerException("holder is null");
            }
        }
    }

    public void m_247654_(T value) {
        throw new UnsupportedOperationException();
    }

    public void m_205769_(Collection<TagKey<T>> tags) {
        throw new UnsupportedOperationException();
    }

    public T m_203334_() {
        this.bindHolder(true);
        return (T)super.m_203334_();
    }

    public boolean m_203633_() {
        this.bindHolder(false);
        return super.m_203633_();
    }

    public boolean m_203656_(TagKey<T> tagKey) {
        this.bindHolder(true);
        return this.holder.m_203656_(tagKey);
    }

    public Stream<TagKey<T>> m_203616_() {
        this.bindHolder(true);
        return this.holder.m_203616_();
    }

    public boolean m_203401_(HolderOwner<T> owner) {
        this.bindHolder(true);
        return this.holder.m_203401_(owner);
    }

    public String toString() {
        return "Reference{" + this.m_205785_() + (String)(this.supplier == null ? "=" + this.m_203334_() : "") + "}";
    }
}

