/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.event;

import com.google.common.collect.ForwardingMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public final class AttributeModifiersMultimap
extends ForwardingMultimap<Attribute, AttributeModifier> {
    private final Supplier<Multimap<Attribute, AttributeModifier>> getModifiers;
    private final BiPredicate<Attribute, AttributeModifier> addModifier;
    private final BiPredicate<Attribute, AttributeModifier> removeModifier;
    private final Function<Attribute, Collection<AttributeModifier>> removeAttribute;
    private final Runnable clearModifiers;

    public AttributeModifiersMultimap(Supplier<Multimap<Attribute, AttributeModifier>> getModifiers, BiPredicate<Attribute, AttributeModifier> addModifier, BiPredicate<Attribute, AttributeModifier> removeModifier, Function<Attribute, Collection<AttributeModifier>> removeAttribute, Runnable clearModifiers) {
        this.getModifiers = getModifiers;
        this.addModifier = addModifier;
        this.removeModifier = removeModifier;
        this.removeAttribute = removeAttribute;
        this.clearModifiers = clearModifiers;
    }

    protected Multimap<Attribute, AttributeModifier> delegate() {
        return this.getModifiers.get();
    }

    public void clear() {
        this.clearModifiers.run();
    }

    public boolean put(Attribute key, AttributeModifier value) {
        return this.addModifier.test(key, value);
    }

    public boolean putAll(Attribute key, Iterable<? extends AttributeModifier> values) {
        boolean changed = false;
        for (AttributeModifier attributeModifier : values) {
            changed |= this.put(key, attributeModifier);
        }
        return changed;
    }

    public boolean putAll(Multimap<? extends Attribute, ? extends AttributeModifier> multimap) {
        boolean changed = false;
        for (Map.Entry entry : multimap.entries()) {
            changed |= this.put((Attribute)entry.getKey(), (AttributeModifier)entry.getValue());
        }
        return changed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean remove(Object key, Object value) {
        if (!(key instanceof Attribute)) return false;
        Attribute attribute = (Attribute)key;
        if (!(value instanceof AttributeModifier)) return false;
        AttributeModifier attributeModifier = (AttributeModifier)value;
        if (!this.removeModifier.test(attribute, attributeModifier)) return false;
        return true;
    }

    public Collection<AttributeModifier> removeAll(Object key) {
        Collection<AttributeModifier> collection;
        if (key instanceof Attribute) {
            Attribute attribute = (Attribute)key;
            collection = this.removeAttribute.apply(attribute);
        } else {
            collection = Collections.emptyList();
        }
        return collection;
    }

    public Collection<AttributeModifier> replaceValues(Attribute key, Iterable<? extends AttributeModifier> values) {
        Collection<AttributeModifier> collection = this.removeAll(key);
        this.putAll(key, values);
        return collection;
    }
}

