/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client.init;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fuzs.puzzleslib.api.client.init.v1.ItemModelDisplayOverrides;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;

public abstract class ItemDisplayOverridesImpl
implements ItemModelDisplayOverrides {
    protected final Map<ModelResourceLocation, Map<ItemDisplayContext, ModelResourceLocation>> overrideLocations = Maps.newHashMap();

    @Override
    public final void register(ModelResourceLocation itemModel, ModelResourceLocation itemModelOverride, ItemDisplayContext ... defaultContexts) {
        Objects.requireNonNull(itemModel, "item model is null");
        Objects.requireNonNull(itemModelOverride, "item model override is null");
        Preconditions.checkState((defaultContexts.length > 0 ? 1 : 0) != 0, (Object)"item display contexts is empty");
        Map overrides = this.overrideLocations.computeIfAbsent(itemModel, $ -> Maps.newEnumMap(ItemDisplayContext.class));
        EnumSet<ItemDisplayContext> contextsToOverride = EnumSet.complementOf(Sets.newEnumSet(Arrays.asList(defaultContexts), ItemDisplayContext.class));
        for (ItemDisplayContext context : contextsToOverride) {
            if (overrides.put(context, itemModelOverride) == null) continue;
            throw new IllegalStateException("Attempting to register duplicate item model display override for model %s and display context %s".formatted(itemModel, context));
        }
    }
}

