/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.forge.impl.network;

import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.network.v3.serialization.MessageSerializers;
import fuzs.puzzleslib.forge.impl.core.ForgeProxy;
import fuzs.puzzleslib.impl.network.NetworkHandlerRegistryImpl;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientCommonPacketListener;
import net.minecraft.network.protocol.common.ServerCommonPacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.SimpleChannel;

public class NetworkHandlerForgeV3
extends NetworkHandlerRegistryImpl {
    private SimpleChannel channel;

    public NetworkHandlerForgeV3(ResourceLocation channelName) {
        super(channelName);
    }

    @Override
    public <T extends Record> void registerClientbound$Internal(Class<?> clazz) {
        this.register(clazz, (arg_0, arg_1) -> NetworkHandlerForgeV3.lambda$registerClientbound$Internal$0((ForgeProxy)Proxy.INSTANCE, arg_0, arg_1), NetworkDirection.PLAY_TO_CLIENT);
    }

    @Override
    public <T extends Record> void registerServerbound$Internal(Class<?> clazz) {
        this.register(clazz, (arg_0, arg_1) -> NetworkHandlerForgeV3.lambda$registerServerbound$Internal$1((ForgeProxy)Proxy.INSTANCE, arg_0, arg_1), NetworkDirection.PLAY_TO_SERVER);
    }

    private <T> void register(Class<T> clazz, BiConsumer<T, CustomPayloadEvent.Context> handle, NetworkDirection networkDirection) {
        Objects.requireNonNull(this.channel, "channel is null");
        BiConsumer<Object, FriendlyByteBuf> encoder = (t, friendlyByteBuf) -> MessageSerializers.findByType(clazz).write((FriendlyByteBuf)friendlyByteBuf, t);
        Function<FriendlyByteBuf, Object> decoder = MessageSerializers.findByType(clazz)::read;
        this.channel.messageBuilder(clazz, this.discriminator.getAndIncrement(), networkDirection).encoder(encoder).decoder(decoder).consumerMainThread(handle).add();
    }

    @Override
    public <T extends Record> Packet<ClientCommonPacketListener> toClientboundPacket(T message) {
        Objects.requireNonNull(this.channel, "channel is null");
        Objects.requireNonNull(message, "message is null");
        return NetworkDirection.PLAY_TO_CLIENT.buildPacket(this.channel.toBuffer(message), this.channel.getName()).getThis();
    }

    @Override
    public <T extends Record> Packet<ServerCommonPacketListener> toServerboundPacket(T message) {
        Objects.requireNonNull(this.channel, "channel is null");
        Objects.requireNonNull(message, "message is null");
        return NetworkDirection.PLAY_TO_SERVER.buildPacket(this.channel.toBuffer(message), this.channel.getName()).getThis();
    }

    @Override
    public void build() {
        if (this.channel != null) {
            throw new IllegalStateException("channel is already built");
        }
        this.channel = NetworkHandlerForgeV3.buildSimpleChannel(this.channelName, this.optional);
        super.build();
    }

    static SimpleChannel buildSimpleChannel(ResourceLocation resourceLocation, boolean optional) {
        return ChannelBuilder.named((ResourceLocation)resourceLocation).clientAcceptedVersions((status, remoteVersion) -> optional || status == Channel.VersionTest.Status.PRESENT).serverAcceptedVersions((status, remoteVersion) -> optional || status == Channel.VersionTest.Status.PRESENT).simpleChannel();
    }

    private static /* synthetic */ void lambda$registerServerbound$Internal$1(ForgeProxy rec$, Object x$0, CustomPayloadEvent.Context x$1) {
        rec$.registerServerReceiverV2((Record)x$0, x$1);
    }

    private static /* synthetic */ void lambda$registerClientbound$Internal$0(ForgeProxy rec$, Object x$0, CustomPayloadEvent.Context x$1) {
        rec$.registerClientReceiverV2((Record)x$0, x$1);
    }
}

