/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.forge.impl.core;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.forge.api.core.v1.ForgeModContainerHelper;
import fuzs.puzzleslib.forge.impl.core.ForgeBiomeLoadingHandler;
import fuzs.puzzleslib.forge.impl.core.context.AddReloadListenersContextForgeImpl;
import fuzs.puzzleslib.forge.impl.core.context.BiomeModificationsContextForgeImpl;
import fuzs.puzzleslib.forge.impl.core.context.BlockInteractionsContextForgeImpl;
import fuzs.puzzleslib.forge.impl.core.context.CreativeModeTabContextForgeImpl;
import fuzs.puzzleslib.forge.impl.core.context.CreativeTabContentsContextForgeImpl;
import fuzs.puzzleslib.forge.impl.core.context.DataPackSourcesContextForgeImpl;
import fuzs.puzzleslib.forge.impl.core.context.EntityAttributesCreateContextForgeImpl;
import fuzs.puzzleslib.forge.impl.core.context.EntityAttributesModifyContextForgeImpl;
import fuzs.puzzleslib.forge.impl.core.context.FlammableBlocksContextForgeImpl;
import fuzs.puzzleslib.forge.impl.core.context.FuelBurnTimesContextForgeImpl;
import fuzs.puzzleslib.forge.impl.core.context.SpawnPlacementsContextForgeImpl;
import fuzs.puzzleslib.impl.item.CopyTagRecipe;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public final class ForgeModConstructor {
    private ForgeModConstructor() {
    }

    public static void construct(ModConstructor constructor, String modId, Set<ContentRegistrationFlags> availableFlags, Set<ContentRegistrationFlags> flagsToHandle) {
        ForgeModContainerHelper.getOptionalModEventBus(modId).ifPresent(modEventBus -> {
            HashMultimap biomeModifications = HashMultimap.create();
            ForgeModConstructor.registerContent(constructor, modId, modEventBus, (Multimap<BiomeLoadingPhase, ForgeBiomeLoadingHandler.BiomeModification>)biomeModifications, flagsToHandle);
            ForgeModConstructor.registerModHandlers(constructor, modId, modEventBus, (Multimap<BiomeLoadingPhase, ForgeBiomeLoadingHandler.BiomeModification>)biomeModifications, availableFlags, flagsToHandle);
            ForgeModConstructor.registerHandlers(constructor, modId);
            constructor.onConstructMod();
        });
    }

    private static void registerContent(ModConstructor constructor, String modId, IEventBus modEventBus, Multimap<BiomeLoadingPhase, ForgeBiomeLoadingHandler.BiomeModification> biomeModifications, Set<ContentRegistrationFlags> flagsToHandle) {
        constructor.onRegisterCreativeModeTabs(new CreativeModeTabContextForgeImpl(modEventBus));
        if (flagsToHandle.contains((Object)ContentRegistrationFlags.BIOME_MODIFICATIONS)) {
            ForgeBiomeLoadingHandler.register(modId, modEventBus, biomeModifications);
        }
        if (flagsToHandle.contains((Object)ContentRegistrationFlags.COPY_TAG_RECIPES)) {
            DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.RECIPE_SERIALIZERS, (String)modId);
            deferredRegister.register(modEventBus);
            CopyTagRecipe.registerSerializers((arg_0, arg_1) -> ((DeferredRegister)deferredRegister).register(arg_0, arg_1));
        }
    }

    private static void registerModHandlers(ModConstructor constructor, String modId, IEventBus eventBus, Multimap<BiomeLoadingPhase, ForgeBiomeLoadingHandler.BiomeModification> biomeModifications, Set<ContentRegistrationFlags> availableFlags, Set<ContentRegistrationFlags> flagsToHandle) {
        eventBus.addListener(evt -> evt.enqueueWork(() -> {
            constructor.onCommonSetup();
            constructor.onRegisterFuelBurnTimes(new FuelBurnTimesContextForgeImpl());
            constructor.onRegisterBiomeModifications(new BiomeModificationsContextForgeImpl(biomeModifications, availableFlags));
            constructor.onRegisterFlammableBlocks(new FlammableBlocksContextForgeImpl());
            constructor.onRegisterBlockInteractions(new BlockInteractionsContextForgeImpl());
        }));
        eventBus.addListener(evt -> constructor.onRegisterSpawnPlacements(new SpawnPlacementsContextForgeImpl((SpawnPlacementRegisterEvent)evt)));
        eventBus.addListener(evt -> constructor.onEntityAttributeCreation(new EntityAttributesCreateContextForgeImpl((arg_0, arg_1) -> ((EntityAttributeCreationEvent)evt).put(arg_0, arg_1))));
        eventBus.addListener(evt -> constructor.onEntityAttributeModification(new EntityAttributesModifyContextForgeImpl((arg_0, arg_1, arg_2) -> ((EntityAttributeModificationEvent)evt).add(arg_0, arg_1, arg_2))));
        eventBus.addListener(evt -> constructor.onBuildCreativeModeTabContents(new CreativeTabContentsContextForgeImpl((BuildCreativeModeTabContentsEvent)evt)));
        eventBus.addListener(evt -> {
            if (evt.getPackType() == PackType.SERVER_DATA) {
                constructor.onAddDataPackFinders(new DataPackSourcesContextForgeImpl(arg_0 -> ((AddPackFindersEvent)evt).addRepositorySource(arg_0)));
                if (flagsToHandle.contains((Object)ContentRegistrationFlags.BIOME_MODIFICATIONS)) {
                    evt.addRepositorySource(ForgeBiomeLoadingHandler.buildPack(modId));
                }
            }
        });
    }

    private static void registerHandlers(ModConstructor constructor, String modId) {
        MinecraftForge.EVENT_BUS.addListener(evt -> constructor.onRegisterDataPackReloadListeners(new AddReloadListenersContextForgeImpl(modId, arg_0 -> ((AddReloadListenerEvent)evt).addListener(arg_0))));
    }
}

