/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.forge.impl.client.event;

import com.mojang.math.Transformation;
import fuzs.puzzleslib.forge.api.core.v1.ForgeModContainerHelper;
import fuzs.puzzleslib.forge.mixin.client.accessor.ModelBakeryForgeAccessor;
import fuzs.puzzleslib.impl.PuzzlesLib;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.AtlasSet;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public record ForgeModelBakerImpl(Map<BakedCacheKey, BakedModel> bakedCache, Function<ResourceLocation, UnbakedModel> unbakedModelGetter, Function<Material, TextureAtlasSprite> modelTextureGetter, BakedModel missingModel) implements ModelBaker
{
    private static Map<ResourceLocation, AtlasSet.StitchResult> capturedAtlasPreparations;

    public ForgeModelBakerImpl(ResourceLocation modelLocation, Map<BakedCacheKey, BakedModel> bakedCache, Function<ResourceLocation, UnbakedModel> modelGetter, BiConsumer<ResourceLocation, Material> missingTextureConsumer, BakedModel missingModel) {
        this(bakedCache, modelGetter, material -> {
            Map<ResourceLocation, AtlasSet.StitchResult> atlasPreparations = capturedAtlasPreparations;
            Objects.requireNonNull(atlasPreparations, "atlas preparations is null");
            AtlasSet.StitchResult stitchResult = atlasPreparations.get(material.m_119193_());
            TextureAtlasSprite textureatlassprite = stitchResult.m_245551_(material.m_119203_());
            if (textureatlassprite != null) {
                return textureatlassprite;
            }
            missingTextureConsumer.accept(modelLocation, (Material)material);
            return stitchResult.m_247223_();
        }, missingModel);
    }

    public static void setAtlasPreparations(Map<ResourceLocation, AtlasSet.StitchResult> atlasPreparations) {
        capturedAtlasPreparations = atlasPreparations;
    }

    public UnbakedModel m_245361_(ResourceLocation resourceLocation) {
        return this.unbakedModelGetter.apply(resourceLocation);
    }

    @Nullable
    public BakedModel m_245240_(ResourceLocation resourceLocation, ModelState modelState) {
        return this.bake(resourceLocation, modelState, this.modelTextureGetter);
    }

    @Nullable
    public BakedModel bake(ResourceLocation resourceLocation, ModelState modelState, Function<Material, TextureAtlasSprite> modelTextureGetter) {
        return this.bake(this.m_245361_(resourceLocation), resourceLocation, modelState, modelTextureGetter);
    }

    public BakedModel bake(UnbakedModel unbakedModel, ResourceLocation resourceLocation) {
        return this.bake(unbakedModel, resourceLocation, (ModelState)BlockModelRotation.X0_Y0, this.modelTextureGetter);
    }

    private BakedModel bake(UnbakedModel unbakedModel, ResourceLocation resourceLocation, ModelState modelState, Function<Material, TextureAtlasSprite> modelTextureGetter) {
        BakedCacheKey key = new BakedCacheKey(resourceLocation, modelState.m_6189_(), modelState.m_7538_());
        BakedModel bakedModel = this.bakedCache.get(key);
        if (bakedModel == null) {
            BlockModel blockModel;
            if (unbakedModel instanceof BlockModel && (blockModel = (BlockModel)unbakedModel).m_111490_() == ModelBakery.f_119232_) {
                return ModelBakeryForgeAccessor.puzzleslib$getItemModelGenerator().m_111670_(modelTextureGetter, blockModel).m_111449_((ModelBaker)this, blockModel, modelTextureGetter, modelState, resourceLocation, false);
            }
            try {
                bakedModel = unbakedModel.m_7611_((ModelBaker)this, modelTextureGetter, modelState, resourceLocation);
            }
            catch (Exception exception) {
                PuzzlesLib.LOGGER.warn("Unable to bake model: '{}': {}", (Object)resourceLocation, (Object)exception);
                bakedModel = this.missingModel;
            }
            this.bakedCache.put(key, bakedModel);
        }
        return bakedModel;
    }

    public Function<Material, TextureAtlasSprite> getModelTextureGetter() {
        return this.modelTextureGetter;
    }

    static {
        ForgeModContainerHelper.getOptionalModEventBus("puzzleslib").ifPresent(eventBus -> eventBus.addListener(evt -> {
            capturedAtlasPreparations = null;
        }));
    }

    public record BakedCacheKey(ResourceLocation resourceLocation, Transformation rotation, boolean isUvLocked) {
    }
}

