/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.forge.impl.client.core.context;

import fuzs.puzzleslib.api.client.core.v1.context.KeyMappingsContext;
import fuzs.puzzleslib.api.client.key.v1.KeyActivationHandler;
import fuzs.puzzleslib.forge.impl.client.key.ForgeKeyMappingHelper;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;

public record KeyMappingsContextForgeImpl(Consumer<KeyMapping> consumer) implements KeyMappingsContext
{
    @Override
    public void registerKeyMapping(KeyMapping keyMapping, KeyActivationHandler activationHandler) {
        Objects.requireNonNull(keyMapping, "key mapping is null");
        Objects.requireNonNull(activationHandler, "activation handles is null");
        this.consumer.accept(keyMapping);
        keyMapping.setKeyConflictContext((IKeyConflictContext)ForgeKeyMappingHelper.KEY_CONTEXTS.get((Object)activationHandler.getActivationContext()));
        KeyMappingsContextForgeImpl.registerKeyActivationHandles(keyMapping, activationHandler);
    }

    private static void registerKeyActivationHandles(KeyMapping keyMapping, KeyActivationHandler activationHandler) {
        if (activationHandler.gameHandler() != null) {
            MinecraftForge.EVENT_BUS.addListener(evt -> {
                if (evt.phase != TickEvent.Phase.START) {
                    return;
                }
                Minecraft minecraft = Minecraft.m_91087_();
                if (minecraft.f_91074_ != null) {
                    while (keyMapping.m_90859_()) {
                        activationHandler.gameHandler().accept(minecraft);
                    }
                }
            });
        }
        if (activationHandler.screenHandler() != null) {
            MinecraftForge.EVENT_BUS.addListener(evt -> {
                if (activationHandler.screenType().isInstance(evt.getScreen()) && keyMapping.m_90832_(evt.getKeyCode(), evt.getScanCode())) {
                    activationHandler.screenHandler().accept((Screen)evt.getScreen());
                    evt.setCanceled(true);
                }
            });
        }
    }
}

