/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.forge.impl.client.core.context;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.puzzleslib.api.client.core.v1.context.BuiltinModelItemRendererContext;
import fuzs.puzzleslib.api.client.init.v1.BuiltinItemRenderer;
import fuzs.puzzleslib.api.client.init.v1.ReloadingBuiltInItemRenderer;
import fuzs.puzzleslib.api.core.v1.resources.ForwardingReloadListenerHelper;
import fuzs.puzzleslib.forge.impl.client.core.ForgeClientItemExtensionsImpl;
import fuzs.puzzleslib.forge.mixin.client.accessor.ItemForgeAccessor;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.fml.loading.FMLLoader;
import org.jetbrains.annotations.Nullable;

public record BuiltinModelItemRendererContextForgeImpl(String modId, List<ResourceManagerReloadListener> dynamicRenderers) implements BuiltinModelItemRendererContext
{
    @Override
    public void registerItemRenderer(final BuiltinItemRenderer renderer, ItemLike ... items) {
        if (FMLLoader.getLaunchHandler().isData()) {
            return;
        }
        Objects.requireNonNull(renderer, "renderer is null");
        Objects.requireNonNull(items, "items is null");
        Preconditions.checkState((items.length > 0 ? 1 : 0) != 0, (Object)"items is empty");
        IClientItemExtensions itemExtensions = new IClientItemExtensions(){
            @Nullable
            private BlockEntityWithoutLevelRenderer blockEntityWithoutLevelRenderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.blockEntityWithoutLevelRenderer == null) {
                    this.blockEntityWithoutLevelRenderer = new ForwardingBlockEntityWithoutLevelRenderer(Minecraft.m_91087_(), renderer);
                }
                return this.blockEntityWithoutLevelRenderer;
            }
        };
        for (ItemLike item : items) {
            Objects.requireNonNull(item, "item is null");
            BuiltinModelItemRendererContextForgeImpl.setClientItemExtensions(item.m_5456_(), itemExtensions);
        }
    }

    @Override
    public void registerItemRenderer(ReloadingBuiltInItemRenderer renderer, ItemLike ... items) {
        this.registerItemRenderer((BuiltinItemRenderer)renderer, items);
        String itemName = BuiltInRegistries.f_257033_.m_7981_((Object)items[0].m_5456_()).m_135815_();
        ResourceLocation identifier = new ResourceLocation(this.modId, itemName + "_built_in_model_renderer");
        this.dynamicRenderers.add((ResourceManagerReloadListener)ForwardingReloadListenerHelper.fromResourceManagerReloadListener(identifier, renderer));
    }

    private static void setClientItemExtensions(Item item, final IClientItemExtensions itemExtensions) {
        Object renderProperties = ((ItemForgeAccessor)item).puzzleslib$getRenderProperties();
        ((ItemForgeAccessor)item).puzzleslib$setRenderProperties(renderProperties != null ? new ForgeClientItemExtensionsImpl((IClientItemExtensions)renderProperties){

            @Override
            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return itemExtensions.getCustomRenderer();
            }
        } : itemExtensions);
    }

    private static class ForwardingBlockEntityWithoutLevelRenderer
    extends BlockEntityWithoutLevelRenderer {
        private final BuiltinItemRenderer renderer;

        public ForwardingBlockEntityWithoutLevelRenderer(Minecraft minecraft, BuiltinItemRenderer renderer) {
            super(minecraft.m_167982_(), minecraft.m_167973_());
            this.renderer = renderer;
        }

        public void m_108829_(ItemStack stack, ItemDisplayContext mode, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
            this.renderer.renderByItem(stack, mode, matrices, vertexConsumers, light, overlay);
        }
    }
}

