/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.forge.impl.capability.data;

import fuzs.puzzleslib.api.capability.v3.data.CapabilityComponent;
import fuzs.puzzleslib.api.capability.v3.data.CapabilityKey;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.capability.GlobalCapabilityRegister;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ForgeCapabilityKey<T, C extends CapabilityComponent<T>>
implements CapabilityKey<T, C> {
    private final ResourceLocation identifier;
    private final Capability<C> capability;
    private final Predicate<Object> filter;
    private final Supplier<C> capabilityFactory;
    @Nullable
    protected C fallback;

    public ForgeCapabilityKey(ResourceLocation identifier, Capability<C> capability, Predicate<Object> filter, Supplier<C> capabilityFactory) {
        this.identifier = identifier;
        this.capability = capability;
        this.filter = filter;
        this.capabilityFactory = capabilityFactory;
        GlobalCapabilityRegister.register(this);
    }

    @Override
    public ResourceLocation identifier() {
        return this.identifier;
    }

    @Override
    public C get(@NotNull T holder) {
        Objects.requireNonNull(holder, "holder is null");
        if (holder instanceof ICapabilityProvider) {
            ICapabilityProvider capabilityProvider = (ICapabilityProvider)holder;
            if (this.shouldBeProvidedBy(holder)) {
                CapabilityComponent capabilityComponent = capabilityProvider.getCapability(this.capability).resolve().orElseGet(() -> {
                    if (this.fallback == null) {
                        PuzzlesLib.LOGGER.warn("Requesting invalid capability {} for type {} from holder {}", new Object[]{this.identifier, this.capability.getName(), holder});
                        this.fallback = (CapabilityComponent)this.capabilityFactory.get();
                    }
                    ((CapabilityComponent)this.fallback).initialize(this, holder, true);
                    return this.fallback;
                });
                Objects.requireNonNull(capabilityComponent, "data is null");
                return (C)capabilityComponent;
            }
        }
        throw new IllegalArgumentException("Invalid capability holder %s".formatted(holder));
    }

    @Override
    public boolean isProvidedBy(@Nullable Object holder) {
        return this.shouldBeProvidedBy(holder) && ((ICapabilityProvider)holder).getCapability(this.capability).isPresent();
    }

    public final boolean shouldBeProvidedBy(@Nullable Object holder) {
        return holder instanceof ICapabilityProvider && this.filter.test(holder);
    }

    @FunctionalInterface
    public static interface ForgeCapabilityKeyFactory<T, C extends CapabilityComponent<T>, K extends CapabilityKey<T, C>> {
        public K apply(ResourceLocation var1, Capability<C> var2, Predicate<Object> var3, Supplier<C> var4);
    }
}

