/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v2.tags;

import java.util.Objects;
import java.util.function.Function;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTagAppender<T> {
    protected final TagBuilder tagBuilder;
    @Nullable
    private final Function<T, ResourceKey<T>> keyExtractor;

    protected AbstractTagAppender(TagBuilder tagBuilder, @Nullable Function<T, ResourceKey<T>> keyExtractor) {
        this.tagBuilder = tagBuilder;
        this.keyExtractor = keyExtractor;
    }

    public abstract AbstractTagAppender<T> setReplace(boolean var1);

    public AbstractTagAppender<T> setReplace() {
        return this.setReplace(true);
    }

    public AbstractTagAppender<T> add(String string) {
        return this.add((T)new ResourceLocation(string));
    }

    public AbstractTagAppender<T> add(String ... strings) {
        for (String string : strings) {
            this.add((T)string);
        }
        return this;
    }

    public AbstractTagAppender<T> add(ResourceLocation resourceLocation) {
        this.tagBuilder.m_215900_(resourceLocation);
        return this;
    }

    public AbstractTagAppender<T> add(ResourceLocation ... resourceLocations) {
        for (ResourceLocation resourceLocation : resourceLocations) {
            this.add((T)resourceLocation);
        }
        return this;
    }

    public AbstractTagAppender<T> add(ResourceKey<T> resourceKey) {
        return this.add((T)resourceKey.m_135782_());
    }

    public AbstractTagAppender<T> add(ResourceKey<T> ... resourceKeys) {
        for (ResourceKey<T> resourceKey : resourceKeys) {
            this.add((T)resourceKey);
        }
        return this;
    }

    public AbstractTagAppender<T> add(T value) {
        return this.add((T)this.keyExtractor().apply(value));
    }

    public AbstractTagAppender<T> add(T ... values) {
        for (T value : values) {
            this.add(value);
        }
        return this;
    }

    public AbstractTagAppender<T> addOptional(String string) {
        return this.addOptional(new ResourceLocation(string));
    }

    public AbstractTagAppender<T> addOptional(String ... strings) {
        for (String string : strings) {
            this.addOptional(string);
        }
        return this;
    }

    public AbstractTagAppender<T> addOptional(ResourceLocation resourceLocation) {
        this.tagBuilder.m_215905_(resourceLocation);
        return this;
    }

    public AbstractTagAppender<T> addOptional(ResourceLocation ... resourceLocations) {
        for (ResourceLocation resourceLocation : resourceLocations) {
            this.add((T)resourceLocation);
        }
        return this;
    }

    public AbstractTagAppender<T> addOptional(ResourceKey<T> resourceKey) {
        return this.addOptional(resourceKey.m_135782_());
    }

    public AbstractTagAppender<T> addOptional(ResourceKey<T> ... resourceKeys) {
        for (ResourceKey<T> resourceKey : resourceKeys) {
            this.addOptional(resourceKey);
        }
        return this;
    }

    public AbstractTagAppender<T> addTag(String string) {
        return this.addTag(new ResourceLocation(string));
    }

    public AbstractTagAppender<T> addTag(String ... strings) {
        for (String string : strings) {
            this.addTag(string);
        }
        return this;
    }

    public AbstractTagAppender<T> addTag(ResourceLocation resourceLocation) {
        this.tagBuilder.m_215907_(resourceLocation);
        return this;
    }

    public AbstractTagAppender<T> addTag(ResourceLocation ... resourceLocations) {
        for (ResourceLocation resourceLocation : resourceLocations) {
            this.addTag(resourceLocation);
        }
        return this;
    }

    public AbstractTagAppender<T> addTag(TagKey<T> tagKey) {
        return this.addTag(tagKey.f_203868_());
    }

    public AbstractTagAppender<T> addTag(TagKey<T> ... tagKeys) {
        for (TagKey<T> tagKey : tagKeys) {
            this.addTag(tagKey);
        }
        return this;
    }

    public AbstractTagAppender<T> addOptionalTag(String string) {
        return this.addOptionalTag(new ResourceLocation(string));
    }

    public AbstractTagAppender<T> addOptionalTag(String ... strings) {
        for (String string : strings) {
            this.addOptionalTag(string);
        }
        return this;
    }

    public AbstractTagAppender<T> addOptionalTag(ResourceLocation resourceLocation) {
        this.tagBuilder.m_215909_(resourceLocation);
        return this;
    }

    public AbstractTagAppender<T> addOptionalTag(ResourceLocation ... resourceLocations) {
        for (ResourceLocation resourceLocation : resourceLocations) {
            this.addOptionalTag(resourceLocation);
        }
        return this;
    }

    public AbstractTagAppender<T> addOptionalTag(TagKey<T> tagKey) {
        return this.addOptionalTag(tagKey.f_203868_());
    }

    public AbstractTagAppender<T> addOptionalTag(TagKey<T> ... tagKeys) {
        for (TagKey<T> tagKey : tagKeys) {
            this.addOptionalTag(tagKey);
        }
        return this;
    }

    public AbstractTagAppender<T> remove(String string) {
        return this.remove((T)new ResourceLocation(string));
    }

    public AbstractTagAppender<T> remove(String ... strings) {
        for (String string : strings) {
            this.remove((T)string);
        }
        return this;
    }

    public abstract AbstractTagAppender<T> remove(ResourceLocation var1);

    public AbstractTagAppender<T> remove(ResourceLocation ... resourceLocations) {
        for (ResourceLocation resourceLocation : resourceLocations) {
            this.remove((T)resourceLocation);
        }
        return this;
    }

    public AbstractTagAppender<T> remove(ResourceKey<T> resourceKey) {
        return this.remove((T)resourceKey.m_135782_());
    }

    public AbstractTagAppender<T> remove(ResourceKey<T> ... resourceKeys) {
        for (ResourceKey<T> resourceKey : resourceKeys) {
            this.remove((T)resourceKey);
        }
        return this;
    }

    public AbstractTagAppender<T> remove(T value) {
        return this.remove((T)this.keyExtractor().apply(value));
    }

    public AbstractTagAppender<T> remove(T ... values) {
        for (T value : values) {
            this.remove(value);
        }
        return this;
    }

    public AbstractTagAppender<T> removeTag(String string) {
        return this.removeTag(new ResourceLocation(string));
    }

    public AbstractTagAppender<T> removeTag(String ... strings) {
        for (String string : strings) {
            this.removeTag(string);
        }
        return this;
    }

    public abstract AbstractTagAppender<T> removeTag(ResourceLocation var1);

    public AbstractTagAppender<T> removeTag(ResourceLocation ... resourceLocations) {
        for (ResourceLocation resourceLocation : resourceLocations) {
            this.removeTag(resourceLocation);
        }
        return this;
    }

    public AbstractTagAppender<T> removeTag(TagKey<T> tagKey) {
        return this.removeTag(tagKey.f_203868_());
    }

    public AbstractTagAppender<T> removeTag(TagKey<T> ... tagKeys) {
        for (TagKey<T> tagKey : tagKeys) {
            this.removeTag(tagKey);
        }
        return this;
    }

    private Function<T, ResourceKey<T>> keyExtractor() {
        Objects.requireNonNull(this.keyExtractor, "key extractor is null");
        return this.keyExtractor;
    }
}

