/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v2;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.apache.commons.lang3.StringUtils;

public final class AbstractLootProvider {
    private AbstractLootProvider() {
    }

    public static LootTableProvider createProvider(PackOutput packOutput, LootTableSubProvider provider, LootContextParamSet paramSet) {
        return new LootTableProvider(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(() -> provider, paramSet)));
    }

    public static abstract class Simple
    implements LootTableSubProvider,
    DataProvider {
        private final LootTableProvider provider;
        protected final Map<ResourceLocation, LootTable.Builder> map = Maps.newHashMap();

        public Simple(LootContextParamSet paramSet, DataProviderContext context) {
            this(paramSet, context.getPackOutput());
        }

        public Simple(LootContextParamSet paramSet, PackOutput packOutput) {
            this.provider = AbstractLootProvider.createProvider(packOutput, this, paramSet);
        }

        public final CompletableFuture<?> m_213708_(CachedOutput output) {
            return this.provider.m_213708_(output);
        }

        public String m_6055_() {
            return String.join((CharSequence)" ", StringUtils.splitByCharacterTypeCamelCase((String)this.getClass().getSimpleName()));
        }

        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> exporter) {
            this.addLootTables();
            this.map.forEach(exporter);
        }

        protected void add(ResourceLocation table, LootTable.Builder builder) {
            this.map.put(table, builder);
        }

        public abstract void addLootTables();
    }

    public static abstract class EntityTypes
    extends EntityLootSubProvider
    implements DataProvider {
        private final LootTableProvider provider;
        protected final String modId;

        public EntityTypes(DataProviderContext context) {
            this(context.getModId(), context.getPackOutput());
        }

        public EntityTypes(String modId, PackOutput packOutput) {
            super(FeatureFlags.f_244280_.m_247355_());
            this.provider = AbstractLootProvider.createProvider(packOutput, (LootTableSubProvider)this, LootContextParamSets.f_81415_);
            this.modId = modId;
        }

        public final CompletableFuture<?> m_213708_(CachedOutput output) {
            return this.provider.m_213708_(output);
        }

        public String m_6055_() {
            return "Entity Type Loot Tables";
        }

        public final void m_246942_() {
            this.addLootTables();
        }

        public abstract void addLootTables();

        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            this.m_246942_();
            HashSet set = Sets.newHashSet();
            for (Map.Entry entry : BuiltInRegistries.f_256780_.m_6579_()) {
                ResourceKey resourceKey = (ResourceKey)entry.getKey();
                EntityType entityType = (EntityType)entry.getValue();
                if (!resourceKey.m_135782_().m_135827_().equals(this.modId)) continue;
                Map map = (Map)this.f_244213_.remove(entityType);
                if (this.m_245552_(entityType)) {
                    ResourceLocation resourceLocation = entityType.m_20677_();
                    if (!(resourceLocation.equals((Object)BuiltInLootTables.f_78712_) || map != null && map.containsKey(resourceLocation))) {
                        throw new IllegalStateException(String.format(Locale.ROOT, "Missing loot table '%s' for '%s'", resourceLocation, resourceKey.m_135782_()));
                    }
                    if (map == null) continue;
                    map.forEach((resourceLocationx, builder) -> {
                        if (!set.add(resourceLocationx)) {
                            throw new IllegalStateException(String.format(Locale.ROOT, "Duplicate loot table '%s' for '%s'", resourceLocationx, resourceKey.m_135782_()));
                        }
                        consumer.accept((ResourceLocation)resourceLocationx, (LootTable.Builder)builder);
                    });
                    continue;
                }
                if (map == null) continue;
                throw new IllegalStateException(String.format(Locale.ROOT, "Weird loot table(s) '%s' for '%s', not a LivingEntity so should not have loot", map.keySet().stream().map(ResourceLocation::toString).collect(Collectors.joining(",")), resourceKey.m_135782_()));
            }
            if (!this.f_244213_.isEmpty()) {
                throw new IllegalStateException("Created loot tables for entities not supported by data pack: " + this.f_244213_.keySet());
            }
        }

        protected boolean m_245552_(EntityType<?> entityType) {
            return entityType.m_20674_() != MobCategory.MISC;
        }
    }

    public static abstract class Blocks
    extends BlockLootSubProvider
    implements DataProvider {
        private final LootTableProvider provider;
        protected final String modId;

        public Blocks(DataProviderContext context) {
            this(context.getModId(), context.getPackOutput());
        }

        public Blocks(String modId, PackOutput packOutput) {
            super(Collections.emptySet(), FeatureFlags.f_244280_.m_247355_());
            this.provider = AbstractLootProvider.createProvider(packOutput, (LootTableSubProvider)this, LootContextParamSets.f_81421_);
            this.modId = modId;
        }

        public final CompletableFuture<?> m_213708_(CachedOutput output) {
            return this.provider.m_213708_(output);
        }

        public String m_6055_() {
            return "Block Loot Tables";
        }

        public final void m_245660_() {
            this.addLootTables();
        }

        public abstract void addLootTables();

        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            this.m_245660_();
            HashSet set = Sets.newHashSet();
            for (Map.Entry entry : BuiltInRegistries.f_256975_.m_6579_()) {
                ResourceLocation resourceLocation;
                ResourceKey resourceKey = (ResourceKey)entry.getKey();
                Block block = (Block)entry.getValue();
                if (!resourceKey.m_135782_().m_135827_().equals(this.modId) || !block.m_245993_(this.f_243739_) || (resourceLocation = block.m_60589_()) == BuiltInLootTables.f_78712_ || !resourceLocation.m_135827_().equals(this.modId) || !set.add(resourceLocation)) continue;
                LootTable.Builder builder = (LootTable.Builder)this.f_244441_.remove(resourceLocation);
                if (builder == null) {
                    throw new IllegalStateException("Missing loot table '%s' for '%s'".formatted(resourceLocation, resourceKey.m_135782_()));
                }
                consumer.accept(resourceLocation, builder);
            }
            if (!this.f_244441_.isEmpty()) {
                throw new IllegalStateException("Created block loot tables for non-blocks: " + this.f_244441_.keySet());
            }
        }

        protected void dropNothing(Block block) {
            this.m_247577_(block, Blocks.m_246386_());
        }
    }
}

