/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v2;

import com.mojang.serialization.Codec;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.AdvancementSubProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAdvancementProvider
implements DataProvider,
AdvancementSubProvider {
    private final PackOutput.PathProvider pathProvider;
    private final CompletableFuture<HolderLookup.Provider> registries;
    protected final String modId;

    public AbstractAdvancementProvider(DataProviderContext context) {
        this(context.getModId(), context.getPackOutput(), context.getLookupProvider());
    }

    public AbstractAdvancementProvider(String modId, PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        this.pathProvider = output.m_245269_(PackOutput.Target.DATA_PACK, "advancements");
        this.registries = registries;
        this.modId = modId;
    }

    protected static DisplayInfo display(ItemStack itemStack, ResourceLocation resourceLocation) {
        return AbstractAdvancementProvider.display(itemStack, resourceLocation, AdvancementType.TASK);
    }

    protected static DisplayInfo display(ItemStack itemStack, ResourceLocation resourceLocation, AdvancementType advancementType) {
        return AbstractAdvancementProvider.display(itemStack, resourceLocation, null, advancementType, false);
    }

    protected static DisplayInfo display(ItemStack itemStack, ResourceLocation resourceLocation, @Nullable ResourceLocation background, AdvancementType advancementType, boolean hidden) {
        return AbstractAdvancementProvider.display(itemStack, resourceLocation, background, advancementType, true, true, hidden);
    }

    protected static DisplayInfo display(ItemStack itemStack, ResourceLocation resourceLocation, @Nullable ResourceLocation background, AdvancementType advancementType, boolean showToast, boolean announceChat, boolean hidden) {
        AdvancementToken advancementToken = new AdvancementToken(resourceLocation);
        return new DisplayInfo(itemStack, advancementToken.title(), advancementToken.description(), Optional.ofNullable(background), advancementType, true, true, hidden);
    }

    public CompletableFuture<?> m_213708_(CachedOutput output) {
        return this.registries.thenCompose(provider -> {
            HashSet set = new HashSet();
            ArrayList list = new ArrayList();
            Consumer<AdvancementHolder> consumer = advancementHolder -> {
                ResourceLocation resourceLocation = new ResourceLocation(this.modId, advancementHolder.f_291758_().m_135815_());
                if (!set.add(resourceLocation)) {
                    throw new IllegalStateException("Duplicate advancement " + resourceLocation);
                }
                Path path = this.pathProvider.m_245731_(resourceLocation);
                list.add(DataProvider.m_293028_((CachedOutput)output, (Codec)Advancement.f_303179_, (Object)advancementHolder.f_290952_(), (Path)path));
            };
            this.m_245571_((HolderLookup.Provider)provider, consumer);
            return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
        });
    }

    public final void m_245571_(HolderLookup.Provider registries, Consumer<AdvancementHolder> writer) {
        this.addAdvancements(registries, writer);
    }

    public abstract void addAdvancements(HolderLookup.Provider var1, Consumer<AdvancementHolder> var2);

    public String m_6055_() {
        return "Advancements";
    }

    public record AdvancementToken(ResourceLocation id) {
        public Component title() {
            return Component.m_237115_((String)this.id.m_269108_("advancements", "title"));
        }

        public Component description() {
            return Component.m_237115_((String)this.id.m_269108_("advancements", "description"));
        }

        public AdvancementHolder asParent() {
            return new AdvancementHolder(this.id, null);
        }

        public String name() {
            return this.id.m_135815_();
        }
    }
}

