/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.config.v3.serialization;

import fuzs.puzzleslib.impl.config.serialization.EnumProvider;
import fuzs.puzzleslib.impl.config.serialization.RegistryProvider;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public interface KeyedValueProvider<T> {
    public static <T> KeyedValueProvider<T> registryEntries(ResourceKey<? extends Registry<? super T>> registryKey) {
        return new RegistryProvider(registryKey);
    }

    public static <T extends Enum<T>> KeyedValueProvider<T> enumConstants(Class<T> enumClazz) {
        return KeyedValueProvider.enumConstants(enumClazz, "minecraft");
    }

    public static <T extends Enum<T>> KeyedValueProvider<T> enumConstants(Class<T> enumClazz, String modId) {
        return new EnumProvider<T>(enumClazz, modId);
    }

    @SafeVarargs
    public static <T> List<String> toString(ResourceKey<? extends Registry<? super T>> registryKey, T ... entries) {
        return KeyedValueProvider.toString(KeyedValueProvider.registryEntries(registryKey), entries);
    }

    @SafeVarargs
    public static <T extends Enum<T>> List<String> toString(Class<T> enumClazz, T ... entries) {
        return KeyedValueProvider.toString(enumClazz, (String)"minecraft", entries);
    }

    @SafeVarargs
    public static <T extends Enum<T>> List<String> toString(Class<T> enumClazz, String modId, T ... entries) {
        return KeyedValueProvider.toString(KeyedValueProvider.enumConstants(enumClazz, modId), entries);
    }

    @SafeVarargs
    public static <T> List<String> toString(KeyedValueProvider<T> valueProvider, T ... entries) {
        return Stream.of(entries).peek(Objects::requireNonNull).map(valueProvider::getKey).filter(Objects::nonNull).map(ResourceLocation::toString).collect(Collectors.toList());
    }

    public Optional<T> getValue(ResourceLocation var1);

    public ResourceLocation getKey(T var1);

    public Stream<Map.Entry<ResourceLocation, T>> stream();

    public Stream<T> streamValues();

    public String name();
}

