/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.packs.v1;

import com.mojang.blaze3d.platform.NativeImage;
import fuzs.puzzleslib.api.resources.v1.AbstractModPackResources;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public class DynamicallyCopiedPackResources
extends AbstractModPackResources {
    private final ResourceManager resourceManager;
    private final VanillaPackResources vanillaPackResources;
    private final Map<ResourceLocation, TextureCopy> textures;

    protected DynamicallyCopiedPackResources(TextureCopy ... textures) {
        Minecraft minecraft = Minecraft.m_91087_();
        this.resourceManager = minecraft.m_91098_();
        this.vanillaPackResources = minecraft.m_246804_();
        this.textures = Stream.of(textures).collect(Collectors.toMap(TextureCopy::destinationLocation, Function.identity()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType packType, ResourceLocation resourceLocation) {
        if (!this.textures.containsKey(resourceLocation)) return null;
        TextureCopy textureCopy = this.textures.get(resourceLocation);
        Optional vanillaResource = this.resourceManager.m_213713_(textureCopy.vanillaLocation());
        if (!vanillaResource.isPresent()) return null;
        try (NativeImage nativeImage = NativeImage.m_85058_((InputStream)((Resource)vanillaResource.get()).m_215507_());){
            if (nativeImage.m_84982_() / nativeImage.m_85084_() == textureCopy.vanillaImageWidth() / textureCopy.vanillaImageHeight()) return () -> ((Resource)((Resource)vanillaResource.get())).m_215507_();
            IoSupplier ioSupplier = this.vanillaPackResources.m_214146_(packType, textureCopy.vanillaLocation());
            return ioSupplier;
        }
        catch (IOException iOException) {
        }
        return () -> ((Resource)((Resource)vanillaResource.get())).m_215507_();
    }

    @Override
    public Set<String> m_5698_(PackType packType) {
        return this.textures.keySet().stream().map(ResourceLocation::m_135827_).collect(Collectors.toSet());
    }

    public static Supplier<AbstractModPackResources> create(TextureCopy ... textures) {
        return () -> new DynamicallyCopiedPackResources(textures);
    }

    public record TextureCopy(ResourceLocation vanillaLocation, ResourceLocation destinationLocation, int vanillaImageWidth, int vanillaImageHeight) {
        public TextureCopy {
            if (vanillaLocation.m_135827_().equals(destinationLocation.m_135827_())) {
                throw new IllegalStateException("%s and %s share same namespace".formatted(vanillaLocation, destinationLocation));
            }
            if (!vanillaLocation.m_135815_().endsWith(".png")) {
                throw new IllegalArgumentException("%s is no texture location".formatted(vanillaLocation));
            }
            if (!destinationLocation.m_135815_().endsWith(".png")) {
                throw new IllegalArgumentException("%s is no texture location".formatted(destinationLocation));
            }
        }
    }
}

