/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.gui.v2.components;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import fuzs.puzzleslib.api.client.core.v1.ClientAbstractions;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public final class TooltipRenderHelper {
    private TooltipRenderHelper() {
    }

    public static List<Component> getTooltipLines(ItemStack itemStack) {
        return TooltipRenderHelper.getTooltipLines(itemStack, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_));
    }

    public static List<Component> getTooltipLines(ItemStack itemStack, TooltipFlag tooltipFlag) {
        Objects.requireNonNull(itemStack, "item stack is null");
        Objects.requireNonNull(tooltipFlag, "tooltip flag is null");
        return itemStack.m_41651_((Player)Minecraft.m_91087_().f_91074_, tooltipFlag);
    }

    public static List<ClientTooltipComponent> getTooltip(ItemStack itemStack) {
        return TooltipRenderHelper.getTooltip(itemStack, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_));
    }

    public static List<ClientTooltipComponent> getTooltip(ItemStack itemStack, TooltipFlag tooltipFlag) {
        Objects.requireNonNull(itemStack, "item stack is null");
        Objects.requireNonNull(tooltipFlag, "tooltip flag is null");
        List<Component> components = TooltipRenderHelper.getTooltipLines(itemStack, tooltipFlag);
        List<TooltipComponent> imageComponents = itemStack.m_150921_().map(List::of).orElse(List.of());
        return TooltipRenderHelper.createClientComponents(components, imageComponents);
    }

    public static void renderTooltip(GuiGraphics guiGraphics, int posX, int posY, ItemStack itemStack) {
        Objects.requireNonNull(itemStack, "item stack is null");
        TooltipRenderHelper.renderTooltipComponents(guiGraphics, posX, posY, TooltipRenderHelper.getTooltip(itemStack));
    }

    public static void renderTooltip(GuiGraphics guiGraphics, int posX, int posY, Component component, TooltipComponent imageComponent) {
        Objects.requireNonNull(component, "component is null");
        Objects.requireNonNull(imageComponent, "image component is null");
        TooltipRenderHelper.renderTooltip(guiGraphics, posX, posY, List.of(component), imageComponent);
    }

    public static void renderTooltip(GuiGraphics guiGraphics, int posX, int posY, List<Component> components, TooltipComponent imageComponent) {
        Objects.requireNonNull(imageComponent, "image component is null");
        TooltipRenderHelper.renderTooltip(guiGraphics, posX, posY, components, List.of(imageComponent));
    }

    public static void renderTooltip(GuiGraphics guiGraphics, int posX, int posY, List<Component> components) {
        TooltipRenderHelper.renderTooltip(guiGraphics, posX, posY, components, List.of());
    }

    public static void renderTooltip(GuiGraphics guiGraphics, int posX, int posY, List<Component> components, List<TooltipComponent> imageComponents) {
        TooltipRenderHelper.renderTooltipComponents(guiGraphics, posX, posY, TooltipRenderHelper.createClientComponents(components, imageComponents));
    }

    public static List<ClientTooltipComponent> createClientComponents(List<Component> components, List<TooltipComponent> imageComponents) {
        return TooltipRenderHelper.createClientComponents(components, imageComponents, 1);
    }

    public static List<ClientTooltipComponent> createClientComponents(List<Component> components, List<TooltipComponent> imageComponents, int insertAt) {
        List clientComponents = components.stream().map(Component::m_7532_).map(ClientTooltipComponent::m_169948_).collect(Collectors.toList());
        List<ClientTooltipComponent> clientImageComponents = imageComponents.stream().map(ClientAbstractions.INSTANCE::createImageComponent).toList();
        if (insertAt == -1) {
            clientComponents.addAll(clientImageComponents);
        } else {
            clientComponents.addAll(insertAt, clientImageComponents);
        }
        return ImmutableList.copyOf(clientComponents);
    }

    @Deprecated(forRemoval=true)
    public static void renderTooltipInternal(GuiGraphics guiGraphics, int posX, int posY, List<ClientTooltipComponent> components) {
        TooltipRenderHelper.renderTooltipComponents(guiGraphics, posX, posY, components);
    }

    public static void renderTooltipComponents(GuiGraphics guiGraphics, int posX, int posY, List<? extends ClientTooltipComponent> components) {
        ClientTooltipComponent clientTooltipComponent2;
        int q;
        if (components.isEmpty()) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        boolean result = ClientAbstractions.INSTANCE.onRenderTooltip(guiGraphics, minecraft.f_91062_, posX, posY, components, DefaultTooltipPositioner.f_262752_);
        if (result) {
            return;
        }
        int i = 0;
        int j = components.size() == 1 ? -2 : 0;
        for (ClientTooltipComponent component : components) {
            int k = component.m_142069_(minecraft.f_91062_);
            if (k > i) {
                i = k;
            }
            j += component.m_142103_();
        }
        int l = posX + 12;
        int m = posY - 12;
        guiGraphics.m_280168_().m_85836_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        TooltipRenderUtil.m_280205_((GuiGraphics)guiGraphics, (int)l, (int)m, (int)i, (int)j, (int)400);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        int p = m;
        for (q = 0; q < components.size(); ++q) {
            clientTooltipComponent2 = components.get(q);
            clientTooltipComponent2.m_142440_(minecraft.f_91062_, l, p, guiGraphics.m_280168_().m_85850_().m_252922_(), bufferSource);
            p += clientTooltipComponent2.m_142103_() + (q == 0 ? 2 : 0);
        }
        bufferSource.m_109911_();
        p = m;
        for (q = 0; q < components.size(); ++q) {
            clientTooltipComponent2 = components.get(q);
            clientTooltipComponent2.m_183452_(minecraft.f_91062_, l, p, guiGraphics);
            p += clientTooltipComponent2.m_142103_() + (q == 0 ? 2 : 0);
        }
        guiGraphics.m_280168_().m_85849_();
    }
}

