/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.data.v2;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatType;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.ApiStatus;

public abstract class AbstractLanguageProvider
implements DataProvider {
    protected final String languageCode;
    protected final String modId;
    protected final PackOutput.PathProvider pathProvider;

    public AbstractLanguageProvider(DataProviderContext context) {
        this(context.getModId(), context.getPackOutput());
    }

    public AbstractLanguageProvider(String languageCode, DataProviderContext context) {
        this(languageCode, context.getModId(), context.getPackOutput());
    }

    public AbstractLanguageProvider(String modId, PackOutput packOutput) {
        this("en_us", modId, packOutput);
    }

    public AbstractLanguageProvider(String languageCode, String modId, PackOutput packOutput) {
        this.languageCode = languageCode;
        this.modId = modId;
        this.pathProvider = packOutput.m_245269_(PackOutput.Target.RESOURCE_PACK, "lang");
    }

    public abstract void addTranslations(TranslationBuilder var1);

    public CompletableFuture<?> m_213708_(CachedOutput writer) {
        JsonObject jsonObject = new JsonObject();
        this.addTranslations((key, value) -> {
            Objects.requireNonNull(key, "key is null");
            Objects.requireNonNull(value, "value is null");
            if (jsonObject.has(key)) {
                throw new IllegalStateException("Duplicate translation key found: " + key);
            }
            jsonObject.addProperty(key, value);
        });
        return DataProvider.m_253162_((CachedOutput)writer, (JsonElement)jsonObject, (Path)this.pathProvider.m_245731_(new ResourceLocation(this.modId, this.languageCode)));
    }

    public String m_6055_() {
        return "Language (%s)".formatted(this.languageCode);
    }

    @FunctionalInterface
    @ApiStatus.NonExtendable
    public static interface TranslationBuilder {
        public void add(String var1, String var2);

        default public void add(String key, String additionalKey, String value) {
            Objects.requireNonNull(additionalKey, "additional key is null");
            this.add(key + (String)(additionalKey.isEmpty() ? "" : "." + additionalKey), value);
        }

        default public void add(ResourceLocation identifier, String value) {
            this.add(identifier, "", value);
        }

        default public void add(ResourceLocation identifier, String additionalKey, String value) {
            Objects.requireNonNull(identifier, "identifier is null");
            this.add(identifier.m_214298_(), additionalKey, value);
        }

        default public void add(String registry, Holder<?> holder, String value) {
            Objects.requireNonNull(registry, "registry is null");
            Objects.requireNonNull(holder, "holder is null");
            this.add(registry, (ResourceKey)holder.m_203543_().orElseThrow(), value);
        }

        default public void add(String registry, ResourceKey<?> resourceKey, String value) {
            Objects.requireNonNull(registry, "registry is null");
            Objects.requireNonNull(resourceKey, "resource key is null");
            this.add(registry, resourceKey.m_135782_(), value);
        }

        default public void add(String registry, ResourceLocation resourceLocation, String value) {
            Objects.requireNonNull(registry, "registry is null");
            Objects.requireNonNull(resourceLocation, "resource location is null");
            this.add(Util.m_137492_((String)registry, (ResourceLocation)resourceLocation), value);
        }

        default public void add(Block block, String value) {
            this.add(block, "", value);
        }

        default public void add(Block block, String additionalKey, String value) {
            Objects.requireNonNull(block, "block is null");
            this.add(block.m_7705_(), additionalKey, value);
        }

        default public void addSpawnEgg(Item item, String value) {
            if (!(item instanceof SpawnEggItem)) {
                throw new IllegalArgumentException("Unsupported item: " + item);
            }
            this.add(item, value + " Spawn Egg");
        }

        default public void add(Item item, String value) {
            this.add(item, "", value);
        }

        default public void add(Item item, String additionalKey, String value) {
            Objects.requireNonNull(item, "item is null");
            this.add(item.m_5524_(), additionalKey, value);
        }

        default public void add(Enchantment enchantment, String value) {
            this.add(enchantment, "", value);
        }

        default public void add(Enchantment enchantment, String additionalKey, String value) {
            Objects.requireNonNull(enchantment, "enchantment is null");
            this.add(enchantment.m_44704_(), additionalKey, value);
        }

        default public void add(MobEffect mobEffect, String value) {
            this.add(mobEffect, "", value);
        }

        default public void add(MobEffect mobEffect, String additionalKey, String value) {
            Objects.requireNonNull(mobEffect, "mob effect is null");
            this.add(mobEffect.m_19481_(), additionalKey, value);
        }

        default public void add(EntityType<?> entityType, String value) {
            this.add(entityType, "", value);
        }

        default public void add(EntityType<?> entityType, String additionalKey, String value) {
            Objects.requireNonNull(entityType, "entity type is null");
            this.add(entityType.m_20675_(), additionalKey, value);
        }

        default public void add(Attribute attribute, String value) {
            this.add(attribute, "", value);
        }

        default public void add(Attribute attribute, String additionalKey, String value) {
            Objects.requireNonNull(attribute, "attribute is null");
            this.add(attribute.m_22087_(), additionalKey, value);
        }

        default public void add(StatType<?> statType, String value) {
            this.add(statType, "", value);
        }

        default public void add(StatType<?> statType, String additionalKey, String value) {
            Objects.requireNonNull(statType, "stat type is null");
            Objects.requireNonNull(statType.m_12905_(), "component is null");
            ComponentContents componentContents = statType.m_12905_().m_214077_();
            if (!(componentContents instanceof TranslatableContents)) {
                throw new IllegalArgumentException("Unsupported component: " + statType.m_12905_());
            }
            TranslatableContents contents = (TranslatableContents)componentContents;
            this.add(contents.m_237508_(), value);
        }

        default public void add(GameRules.Key<?> gameRule, String value) {
            this.add(gameRule, "", value);
        }

        default public void addGameRuleDescription(GameRules.Key<?> gameRule, String value) {
            this.add(gameRule, "description", value);
        }

        default public void add(GameRules.Key<?> gameRule, String additionalKey, String value) {
            Objects.requireNonNull(gameRule, "game rule is null");
            this.add(gameRule.m_46331_(), additionalKey, value);
        }

        default public void add(Potion potion, String value) {
            Objects.requireNonNull(potion, "potion is null");
            String potionName = potion.m_43492_("");
            this.add("item.minecraft.tipped_arrow.effect." + potionName, "Arrow of " + value);
            this.add("item.minecraft.potion.effect." + potionName, "Potion of " + value);
            this.add("item.minecraft.splash_potion.effect." + potionName, "Splash Potion of " + value);
            this.add("item.minecraft.lingering_potion.effect." + potionName, "Lingering Potion of " + value);
        }

        default public void add(SoundEvent soundEvent, String value) {
            Objects.requireNonNull(soundEvent, "sound event is null");
            this.add("subtitles." + soundEvent.m_11660_().m_135815_(), value);
        }

        default public void add(KeyMapping keyMapping, String value) {
            Objects.requireNonNull(keyMapping, "key mapping is null");
            this.add(keyMapping.m_90860_(), value);
        }

        default public void addKeyCategory(String modId, String value) {
            this.add("key.categories." + modId, value);
        }

        default public void addCreativeModeTab(String modId, String value) {
            this.addCreativeModeTab(modId, "main", value);
        }

        default public void addCreativeModeTab(String modId, String tabId, String value) {
            Objects.requireNonNull(modId, "mod id is null");
            Objects.requireNonNull(tabId, "tab id is null");
            this.addCreativeModeTab(new ResourceLocation(modId, tabId), value);
        }

        default public void addCreativeModeTab(ResourceLocation identifier, String value) {
            Objects.requireNonNull(identifier, "identifier is null");
            this.addCreativeModeTab((ResourceKey<CreativeModeTab>)ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)identifier), value);
        }

        default public void addCreativeModeTab(ResourceKey<CreativeModeTab> resourceKey, String value) {
            Objects.requireNonNull(resourceKey, "resource key is null");
            this.add((CreativeModeTab)BuiltInRegistries.f_279662_.m_6246_(resourceKey), value);
        }

        default public void add(CreativeModeTab tab, String value) {
            Objects.requireNonNull(tab, "tab is null");
            this.add(tab.m_40786_(), value);
        }

        default public void add(Component component, String value) {
            Objects.requireNonNull(component, "component is null");
            ComponentContents componentContents = component.m_214077_();
            if (!(componentContents instanceof TranslatableContents)) {
                throw new IllegalArgumentException("Unsupported component: " + component);
            }
            TranslatableContents contents = (TranslatableContents)componentContents;
            this.add(contents.m_237508_(), value);
        }

        default public void addGenericDamageType(ResourceKey<DamageType> damageType, String value) {
            Objects.requireNonNull(damageType, "damage type is null");
            this.add("death.attack." + damageType.m_135782_().m_135815_(), value);
        }

        default public void addPlayerDamageType(ResourceKey<DamageType> damageType, String value) {
            Objects.requireNonNull(damageType, "damage type is null");
            this.add("death.attack." + damageType.m_135782_().m_135815_() + ".player", value);
        }

        default public void addItemDamageType(ResourceKey<DamageType> damageType, String value) {
            Objects.requireNonNull(damageType, "damage type is null");
            this.add("death.attack." + damageType.m_135782_().m_135815_() + ".item", value);
        }
    }
}

