/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdeserttemples.world.state;

import com.yungnickyoung.minecraft.betterdeserttemples.BetterDesertTemplesCommon;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;

public class TempleStateRegion {
    private final String regionKey;
    private final File regionFile;
    private final ConcurrentHashMap<Long, Boolean> templeStateMap = new ConcurrentHashMap();

    public TempleStateRegion(Path basePath, String regionKey) {
        this.regionKey = regionKey;
        this.regionFile = basePath.resolve(regionKey).toFile();
        this.createRegionFileIfDoesNotExist();
    }

    public synchronized void setTempleCleared(BlockPos templePos, boolean isCleared) {
        this.templeStateMap.put(templePos.m_121878_(), isCleared);
        this.createRegionFileIfDoesNotExist();
        CompoundTag compoundTag = this.readRegionFile();
        compoundTag.m_128379_(templePos.toString(), isCleared);
        this.writeRegionFile(compoundTag);
    }

    public synchronized boolean isTempleCleared(BlockPos templePos) {
        long templePosAsLong = templePos.m_121878_();
        if (this.templeStateMap.containsKey(templePosAsLong)) {
            return this.templeStateMap.get(templePosAsLong);
        }
        this.createRegionFileIfDoesNotExist();
        boolean isCleared = false;
        CompoundTag compoundTag = this.readRegionFile();
        if (compoundTag == null) {
            compoundTag = new CompoundTag();
            compoundTag.m_128379_(templePos.toString(), isCleared);
            this.writeRegionFile(compoundTag);
        } else if (compoundTag.m_128441_(templePos.toString())) {
            isCleared = compoundTag.m_128471_(templePos.toString());
        } else {
            compoundTag.m_128379_(templePos.toString(), isCleared);
            this.writeRegionFile(compoundTag);
        }
        this.templeStateMap.put(templePosAsLong, isCleared);
        return isCleared;
    }

    public synchronized void reset() {
        this.templeStateMap.clear();
    }

    private void writeRegionFile(CompoundTag compoundTag) {
        try {
            NbtIo.m_128955_((CompoundTag)compoundTag, (Path)this.regionFile.toPath());
        }
        catch (IOException e) {
            BetterDesertTemplesCommon.LOGGER.error("Encountered error writing data to temple region file {}", (Object)this.regionKey);
            BetterDesertTemplesCommon.LOGGER.error((Object)e);
        }
    }

    private CompoundTag readRegionFile() {
        try {
            return NbtIo.m_128953_((Path)this.regionFile.toPath());
        }
        catch (IOException e) {
            BetterDesertTemplesCommon.LOGGER.error("Encountered error reading data from temple region file {}", (Object)this.regionKey);
            BetterDesertTemplesCommon.LOGGER.error((Object)e);
            return new CompoundTag();
        }
    }

    private synchronized void createRegionFileIfDoesNotExist() {
        if (!this.regionFile.exists()) {
            try {
                this.regionFile.createNewFile();
                NbtIo.m_128955_((CompoundTag)new CompoundTag(), (Path)this.regionFile.toPath());
            }
            catch (IOException e) {
                BetterDesertTemplesCommon.LOGGER.error("Unable to create temple region file for region {}", (Object)this.regionKey);
                BetterDesertTemplesCommon.LOGGER.error((Object)e);
            }
        }
    }
}

