/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdeserttemples.mixin;

import com.yungnickyoung.minecraft.betterdeserttemples.BetterDesertTemplesCommon;
import com.yungnickyoung.minecraft.betterdeserttemples.module.TagModule;
import com.yungnickyoung.minecraft.betterdeserttemples.world.state.ITempleStateCacheProvider;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class PharaohKilledMixin
extends Entity {
    public PharaohKilledMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"die"}, at={@At(value="HEAD")})
    private void betterdeserttemples_pharaohDie(DamageSource damageSource, CallbackInfo info) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!this.isPharaoh((Object)this)) {
            return;
        }
        StructureStart structureStart = serverLevel.m_215010_().m_220491_(this.m_20183_(), TagModule.APPLIES_MINING_FATIGUE);
        if (structureStart.m_73603_()) {
            BlockPos structureStartPos = structureStart.m_163625_().m_45615_();
            ((ITempleStateCacheProvider)this.m_9236_()).getTempleStateCache().setTempleCleared(structureStartPos, true);
            List players = serverLevel.m_6907_();
            players.forEach(player -> {
                if (this.m_9236_().m_46749_(player.m_20183_()) && serverLevel.m_215010_().m_220491_(player.m_20183_(), TagModule.APPLIES_MINING_FATIGUE).m_73603_()) {
                    player.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_11738_), SoundSource.HOSTILE, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, 1.0f, serverLevel.m_7328_()));
                    player.m_21195_(MobEffects.f_19599_);
                }
            });
            BetterDesertTemplesCommon.LOGGER.info("CLEARED TEMPLE AT {}", (Object)structureStartPos);
        }
    }

    private boolean isPharaoh(Object object) {
        if (!(object instanceof Husk)) {
            return false;
        }
        Mob mob = (Mob)object;
        for (ItemStack armorItem : mob.m_6168_()) {
            CompoundTag texture1;
            ListTag textures;
            CompoundTag properties;
            CompoundTag skullOwner;
            CompoundTag compoundTag;
            if (!armorItem.m_150930_(Items.f_42680_) || !armorItem.m_41782_() || !(compoundTag = armorItem.m_41783_()).m_128425_("SkullOwner", 10) || !(skullOwner = compoundTag.m_128469_("SkullOwner")).m_128425_("Properties", 10) || !(properties = skullOwner.m_128469_("Properties")).m_128425_("textures", 9) || (textures = properties.m_128437_("textures", 10)).size() != 1 || !(texture1 = (CompoundTag)textures.get(0)).m_128461_("Value").equals("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTM1MGMwNDk5YTY4YmNkOWM3NWIyNWMxOTIzMTQzOWIxMDhkMDI3NTlmNDM1ZTMzZTRhZWU5ZWQxZGQyNDFhMiJ9fX0=")) continue;
            return true;
        }
        return false;
    }
}

