/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.gui;

import com.chaosthedude.explorerscompass.gui.ExplorersCompassScreen;
import com.chaosthedude.explorerscompass.gui.StructureSearchEntry;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StructureSearchList
extends ObjectSelectionList<StructureSearchEntry> {
    private final ExplorersCompassScreen parentScreen;

    public StructureSearchList(ExplorersCompassScreen parentScreen, Minecraft mc, int width, int height, int top, int bottom) {
        super(mc, width, height, top, bottom);
        this.parentScreen = parentScreen;
        this.refreshList();
    }

    protected int m_5756_() {
        return super.m_5756_() + 20;
    }

    public int m_5759_() {
        return super.m_5759_() + 50;
    }

    protected boolean m_7987_(int slotIndex) {
        return slotIndex >= 0 && slotIndex < this.m_6702_().size() ? ((Object)((Object)((StructureSearchEntry)((Object)this.m_6702_().get(slotIndex))))).equals(this.m_93511_()) : false;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_239227_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    protected void m_239227_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        for (int j = 0; j < this.m_5773_(); ++j) {
            int rowTop = this.m_7610_(j);
            int rowBottom = this.m_93485_(j);
            if (rowBottom < this.m_252907_() || rowTop > this.m_306468_()) continue;
            int j1 = this.f_93387_ - 4;
            StructureSearchEntry entry = (StructureSearchEntry)this.m_93500_(j);
            if (this.m_7987_(j)) {
                int insideLeft = this.m_252754_() + this.f_93618_ / 2 - this.m_5759_() / 2 + 2;
                guiGraphics.m_280509_(insideLeft - 4, rowTop - 4, insideLeft + this.m_5759_() + 4, rowTop + this.f_93387_, 0x7F000000);
            }
            entry.m_6311_(guiGraphics, j, rowTop, this.m_5747_(), this.m_5759_(), j1, mouseX, mouseY, this.m_5953_(mouseX, mouseY) && Objects.equals(this.m_93412_(mouseX, mouseY), (Object)entry), partialTicks);
        }
        if (this.m_93518_() > 0) {
            int left = this.m_5756_();
            int right = left + 6;
            int height = (int)((float)((this.m_306468_() - this.m_252907_()) * (this.m_306468_() - this.m_252907_())) / (float)this.m_5775_());
            height = Mth.m_14045_((int)height, (int)32, (int)(this.m_306468_() - this.m_252907_() - 8));
            int top = (int)this.m_93517_() * (this.m_306468_() - this.m_252907_() - height) / this.m_93518_() + this.m_252907_();
            if (top < this.m_252907_()) {
                top = this.m_252907_();
            }
            guiGraphics.m_280509_(left, this.m_252907_(), right, this.m_306468_(), 0x2B000000);
            guiGraphics.m_280509_(left, top, right, top + height, -234881024);
        }
    }

    protected int m_93485_(int index) {
        return this.m_7610_(index) + this.f_93387_;
    }

    public void refreshList() {
        this.m_93516_();
        for (ResourceLocation key : this.parentScreen.sortStructures()) {
            this.m_7085_((AbstractSelectionList.Entry)new StructureSearchEntry(this, key));
        }
        this.selectStructure(null);
        this.m_93410_(0.0);
    }

    public void selectStructure(StructureSearchEntry entry) {
        this.m_6987_((AbstractSelectionList.Entry)entry);
        this.parentScreen.selectStructure(entry);
    }

    public boolean hasSelection() {
        return this.m_93511_() != null;
    }

    public ExplorersCompassScreen getParentScreen() {
        return this.parentScreen;
    }
}

