/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.client;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.client.ExplorersCompassOverlay;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.util.CompassState;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="explorerscompass", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ExplorersCompassClient {
    @SubscribeEvent
    public static void clientInit(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ItemProperties.register((Item)ExplorersCompass.explorersCompass, (ResourceLocation)new ResourceLocation("angle"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){
            @OnlyIn(value=Dist.CLIENT)
            private double rotation;
            @OnlyIn(value=Dist.CLIENT)
            private double rota;
            @OnlyIn(value=Dist.CLIENT)
            private long lastUpdateTick;

            @OnlyIn(value=Dist.CLIENT)
            public float m_142187_(ItemStack stack, ClientLevel world, LivingEntity entityLiving, int seed) {
                LivingEntity entity;
                if (entityLiving == null && !stack.m_41794_()) {
                    return 0.0f;
                }
                boolean entityExists = entityLiving != null;
                Object object = entity = entityExists ? entityLiving : stack.m_41795_();
                if (world == null && entity.m_9236_() instanceof ClientLevel) {
                    world = (ClientLevel)entity.m_9236_();
                }
                double rotation = entityExists ? (double)entity.m_146908_() : this.getFrameRotation((ItemFrame)entity);
                double adjusted = Math.PI - (((rotation %= 360.0) - 90.0) * 0.01745329238474369 - this.getAngle(world, (Entity)entity, stack));
                if (entityExists) {
                    adjusted = this.wobble(world, adjusted);
                }
                float f = (float)(adjusted / (Math.PI * 2));
                return Mth.m_14091_((float)f, (float)1.0f);
            }

            @OnlyIn(value=Dist.CLIENT)
            private double wobble(ClientLevel world, double amount) {
                if (world.m_46467_() != this.lastUpdateTick) {
                    this.lastUpdateTick = world.m_46467_();
                    double d0 = amount - this.rotation;
                    d0 = Mth.m_14109_((double)(d0 + Math.PI), (double)(Math.PI * 2)) - Math.PI;
                    d0 = Mth.m_14008_((double)d0, (double)-1.0, (double)1.0);
                    this.rota += d0 * 0.1;
                    this.rota *= 0.8;
                    this.rotation += this.rota;
                }
                return this.rotation;
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getFrameRotation(ItemFrame itemFrame) {
                Direction direction = itemFrame.m_6350_();
                int i = direction.m_122434_().m_122478_() ? 90 * direction.m_122421_().m_122540_() : 0;
                return Mth.m_14098_((int)(180 + direction.m_122416_() * 90 + itemFrame.m_31823_() * 45 + i));
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getAngle(ClientLevel world, Entity entity, ItemStack stack) {
                if (stack.m_41720_() == ExplorersCompass.explorersCompass) {
                    ExplorersCompassItem compassItem = (ExplorersCompassItem)stack.m_41720_();
                    BlockPos pos = compassItem.getState(stack) == CompassState.FOUND ? new BlockPos(compassItem.getFoundStructureX(stack), 0, compassItem.getFoundStructureZ(stack)) : world.m_220360_();
                    return Math.atan2((double)pos.m_123343_() - entity.m_20182_().m_7094_(), (double)pos.m_123341_() - entity.m_20182_().m_7096_());
                }
                return 0.0;
            }
        }));
    }

    @SubscribeEvent
    public static void registerOverlay(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.BOSS_EVENT_PROGRESS.id(), "explorers_compass", (IGuiOverlay)new ExplorersCompassOverlay());
    }
}

