/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass;

import com.chaosthedude.explorerscompass.config.ConfigHandler;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.network.CompassSearchPacket;
import com.chaosthedude.explorerscompass.network.SyncPacket;
import com.chaosthedude.explorerscompass.network.TeleportPacket;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="explorerscompass")
public class ExplorersCompass {
    public static final String MODID = "explorerscompass";
    public static final Logger LOGGER = LogManager.getLogger((String)"explorerscompass");
    public static SimpleChannel network;
    public static ExplorersCompassItem explorersCompass;
    public static boolean canTeleport;
    public static List<ResourceLocation> allowedStructureKeys;
    public static ListMultimap<ResourceLocation, ResourceLocation> dimensionKeysForAllowedStructureKeys;
    public static Map<ResourceLocation, ResourceLocation> structureKeysToTypeKeys;
    public static ListMultimap<ResourceLocation, ResourceLocation> typeKeysToStructureKeys;

    public ExplorersCompass() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::buildCreativeTabContents);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigHandler.GENERAL_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigHandler.CLIENT_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        network = ChannelBuilder.named((ResourceLocation)new ResourceLocation(MODID, MODID)).networkProtocolVersion(1).optionalClient().clientAcceptedVersions(Channel.VersionTest.exact((int)1)).simpleChannel();
        network.messageBuilder(CompassSearchPacket.class).encoder(CompassSearchPacket::toBytes).decoder(CompassSearchPacket::new).consumerMainThread(CompassSearchPacket::handle).add();
        network.messageBuilder(TeleportPacket.class).encoder(TeleportPacket::toBytes).decoder(TeleportPacket::new).consumerMainThread(TeleportPacket::handle).add();
        network.messageBuilder(SyncPacket.class).encoder(SyncPacket::toBytes).decoder(SyncPacket::new).consumerMainThread(SyncPacket::handle).add();
        allowedStructureKeys = new ArrayList<ResourceLocation>();
        dimensionKeysForAllowedStructureKeys = ArrayListMultimap.create();
        structureKeysToTypeKeys = new HashMap<ResourceLocation, ResourceLocation>();
        typeKeysToStructureKeys = ArrayListMultimap.create();
    }

    private void buildCreativeTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.m_246342_(new ItemStack((ItemLike)explorersCompass));
        }
    }
}

