/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.ui;

import github.mrh0.buildersaddition2.ui.FilteredSlot;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class GenericStorageMenu
extends AbstractContainerMenu {
    private final Container container;
    private final int containerRows;
    private final int containerColumns;
    private final int slotIconIndex;
    private final Function<ItemStack, Boolean> filter;

    public GenericStorageMenu(MenuType<?> type, int id, Inventory inv, Level level, BlockPos pos, int rows, int columns, int slotIconIndex, Function<ItemStack, Boolean> filter) {
        super(type, id);
        this.container = (Container)level.m_7702_(pos);
        this.containerRows = rows;
        this.containerColumns = columns;
        this.slotIconIndex = slotIconIndex;
        this.filter = filter;
        this.container.m_5856_(inv.f_35978_);
        int slotSize = 18;
        int i = (this.containerRows - 4) * slotSize;
        for (int j = 0; j < this.containerRows; ++j) {
            for (int k = 0; k < this.containerColumns; ++k) {
                this.m_38897_(new FilteredSlot(this.container, k + j * this.containerColumns, 8 + k * slotSize + (9 - this.containerColumns) * slotSize / 2, slotSize + j * slotSize, filter));
            }
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.m_38897_(new Slot((Container)inv, j1 + l * 9 + 9, 8 + j1 * slotSize, 103 + l * slotSize + i));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.m_38897_(new Slot((Container)inv, i1, 8 + i1 * slotSize, 161 + i));
        }
    }

    public GenericStorageMenu(MenuType<?> type, int id, Inventory inv, Level level, BlockPos pos, int rows, int columns, int slotIconIndex) {
        this(type, id, inv, level, pos, rows, columns, slotIconIndex, FilteredSlot.ALLOW_ALL);
    }

    public int getSlotIconIndex() {
        return this.slotIconIndex;
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < this.containerRows * this.containerColumns ? !this.m_38903_(itemstack1, this.containerRows * this.containerColumns, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.containerRows * this.containerColumns, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.container.m_5785_(player);
    }

    public Container getContainer() {
        return this.container;
    }

    public int getRowCount() {
        return this.containerRows;
    }

    public int getColumnCount() {
        return this.containerColumns;
    }
}

