/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.recipe.carpenter;

import github.mrh0.buildersaddition2.recipe.carpenter.CarpenterRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class CarpenterRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final Item result;
    private final int count;
    private final NonNullList<Ingredient> ingredients = NonNullList.m_122779_();
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    @Nullable
    private String group;

    public CarpenterRecipeBuilder(RecipeCategory category, ItemLike item, int count) {
        this.category = category;
        this.result = item.m_5456_();
        this.count = count;
    }

    public static CarpenterRecipeBuilder carpenter(RecipeCategory category, ItemLike item) {
        return new CarpenterRecipeBuilder(category, item, 1);
    }

    public static CarpenterRecipeBuilder carpenter(RecipeCategory category, ItemLike item, int count) {
        return new CarpenterRecipeBuilder(category, item, count);
    }

    public CarpenterRecipeBuilder requires(TagKey<Item> ingredient) {
        return this.requires(Ingredient.m_204132_(ingredient));
    }

    public CarpenterRecipeBuilder requires(ItemLike ingredient) {
        return this.requires(ingredient, 1);
    }

    public CarpenterRecipeBuilder requires(ItemLike item, int count) {
        for (int i = 0; i < count; ++i) {
            this.requires(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
        }
        return this;
    }

    public CarpenterRecipeBuilder requires(Ingredient ingredient) {
        return this.requires(ingredient, 1);
    }

    public CarpenterRecipeBuilder requires(Ingredient ingredient, int count) {
        for (int i = 0; i < count; ++i) {
            this.ingredients.add((Object)ingredient);
        }
        return this;
    }

    public RecipeBuilder m_126132_(String p_176496_, Criterion<?> p_297505_) {
        this.criteria.put(p_176496_, p_297505_);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String group) {
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(RecipeOutput out, ResourceLocation rl) {
        this.ensureValid(rl);
        Advancement.Builder advancement$builder = out.m_293552_().m_138383_("has_the_recipe", RecipeUnlockedTrigger.m_63728_((ResourceLocation)rl)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)rl)).m_138360_(AdvancementRequirements.Strategy.f_291456_);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).m_138383_(arg_0, arg_1));
        CarpenterRecipe recipe = new CarpenterRecipe(Objects.requireNonNullElse(this.group, ""), this.ingredients, new ItemStack((ItemLike)this.result, this.count));
        out.m_292927_(rl, (Recipe)recipe, advancement$builder.m_138403_(rl.m_246208_("recipes/" + this.category.m_247710_() + "/")));
    }

    private void ensureValid(ResourceLocation rl) {
        if (this.criteria.isEmpty()) {
            // empty if block
        }
    }
}

