/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.recipe.carpenter;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CarpenterRecipe
implements Recipe<SimpleContainer> {
    public static final String RECIPE_TYPE_NAME = "carpenter";
    private final NonNullList<Ingredient> inputItems;
    private final ItemStack output;

    public CarpenterRecipe(String group, NonNullList<Ingredient> inputItems, ItemStack output) {
        this.inputItems = inputItems;
        this.output = output;
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.BUILDING;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputItems;
    }

    public boolean matches(SimpleContainer container, Level pLevel) {
        for (int i = 0; i < this.inputItems.size() && !((Ingredient)this.inputItems.get(i)).m_43947_(); ++i) {
            boolean match = false;
            for (int j = 0; j < 4; ++j) {
                if (!((Ingredient)this.inputItems.get(i)).test(container.m_8020_(j))) continue;
                match = true;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(SimpleContainer container, RegistryAccess registry) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registry) {
        return this.output.m_41777_();
    }

    public ItemStack getResultItem() {
        return this.output.m_41777_();
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<CarpenterRecipe> {
        public static final Codec<CarpenterRecipe> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ExtraCodecs.m_295827_((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(recipe -> ""), (App)Ingredient.f_290991_.listOf().fieldOf("ingredients").flatXmap(p_297969_ -> {
            Object[] aingredient = (Ingredient[])p_297969_.stream().filter(p_298915_ -> !p_298915_.m_43947_()).toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return aingredient.length > 4 ? DataResult.error(() -> "Too many ingredients for shapeless recipe") : DataResult.success((Object)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])aingredient));
        }, DataResult::success).forGetter(recipe -> recipe.inputItems), (App)ItemStack.f_302323_.fieldOf("result").forGetter(recipe -> recipe.output)).apply((Applicative)builder, CarpenterRecipe::new));
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("buildersaddition2", "carpenter");

        public Codec<CarpenterRecipe> m_292673_() {
            return CODEC;
        }

        @Nullable
        public CarpenterRecipe fromNetwork(FriendlyByteBuf buff) {
            NonNullList inputs = NonNullList.m_122780_((int)buff.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buff));
            }
            ItemStack output = buff.m_130267_();
            return new CarpenterRecipe("", (NonNullList<Ingredient>)inputs, output);
        }

        public void toNetwork(FriendlyByteBuf buff, CarpenterRecipe recipe) {
            buff.writeInt(recipe.inputItems.size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buff);
            }
            buff.writeItemStack(recipe.m_8043_(null), false);
        }
    }

    public static class Type
    implements RecipeType<CarpenterRecipe> {
        public static final Type INSTANCE = new Type();
    }
}

