/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.network;

import github.mrh0.buildersaddition2.network.IContentProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class SyncContentPacket {
    private BlockPos pos;
    private int count;
    private NonNullList<ItemStack> items;

    public SyncContentPacket(BlockPos pos, int count, NonNullList<ItemStack> items) {
        this.pos = pos;
        this.count = count;
        this.items = items;
    }

    public static void encode(SyncContentPacket pkt, FriendlyByteBuf tag) {
        tag.m_130064_(pkt.pos);
        tag.writeInt(pkt.count);
        for (int i = 0; i < pkt.count; ++i) {
            tag.m_130055_((ItemStack)pkt.items.get(i));
        }
    }

    public static SyncContentPacket decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        int count = buf.readInt();
        NonNullList items = NonNullList.m_182647_((int)count);
        for (int i = 0; i < count; ++i) {
            items.set(i, (Object)buf.m_130267_());
        }
        return new SyncContentPacket(pos, count, (NonNullList<ItemStack>)items);
    }

    public static void handle(SyncContentPacket pkt, CustomPayloadEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            try {
                ServerPlayer player = ctx.getSender();
                if (player != null) {
                    SyncContentPacket.sendUpdate(pkt.pos, player);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ctx.setPacketHandled(true);
    }

    private static void sendUpdate(BlockPos pos, ServerPlayer player) {
        BlockEntity be = player.m_9236_().m_7702_(pos);
        if (be instanceof IContentProvider) {
            IContentProvider provider = (IContentProvider)be;
            Packet packet = be.m_58483_();
            if (packet != null) {
                player.f_8906_.m_141995_(packet);
            }
        }
    }

    public static void send(BlockPos pos, ServerPlayer player) {
    }
}

