/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.common.datagen;

import github.mrh0.buildersaddition2.BA2;
import github.mrh0.buildersaddition2.Index;
import github.mrh0.buildersaddition2.common.BlockBlueprint;
import github.mrh0.buildersaddition2.common.variants.WoodVariant;
import github.mrh0.buildersaddition2.recipe.carpenter.CarpenterRecipeBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;

public class BPRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public BPRecipeProvider(String modid, PackOutput output) {
        super(output);
    }

    protected final void m_245200_(RecipeOutput out) {
        BlockBlueprint.ALL_BLUEPRINTS.forEach(blueprint -> blueprint.generateAllRecipes(this, out));
        WoodVariant.ALL.forEach(wood -> {
            BPRecipeProvider.carpenter(out, wood.getName() + "_stairs_carpentry", (ItemLike)wood.stairs, 1, new ItemLike[]{wood.planks});
            BPRecipeProvider.carpenter(out, wood.getName() + "_slab_carpentry", (ItemLike)wood.slab, 2, new ItemLike[]{wood.planks});
            BPRecipeProvider.carpenter(out, wood.getName() + "_fence_carpentry", (ItemLike)wood.fence, 1, new ItemLike[]{wood.planks, Items.f_42398_});
            BPRecipeProvider.carpenter(out, wood.getName() + "_door_carpentry", (ItemLike)wood.door, 1, new ItemLike[]{wood.planks});
            BPRecipeProvider.carpenter(out, wood.getName() + "_trap_door_carpentry", (ItemLike)wood.trapDoor, 1, new ItemLike[]{wood.planks});
        });
    }

    public static void carpenter(RecipeOutput out, String name, ItemLike result, int count, ItemLike ... required) {
        CarpenterRecipeBuilder builder = CarpenterRecipeBuilder.carpenter(RecipeCategory.DECORATIONS, result, count);
        for (int i = 0; i < Math.min(required.length, 4); ++i) {
            builder.requires(required[i]);
        }
        builder.m_126132_(BPRecipeProvider.m_176602_((ItemLike)Index.CARPENTER_TABLE.getBlock(0)), BPRecipeProvider.m_206406_((ItemLike)Index.CARPENTER_TABLE.getBlock(0))).m_126140_(out, BA2.get(name));
    }

    public static void carpenter(RecipeOutput out, String name, ItemLike result, int count, List<ItemLike> required) {
        CarpenterRecipeBuilder builder = CarpenterRecipeBuilder.carpenter(RecipeCategory.DECORATIONS, result, count);
        for (int i = 0; i < Math.min(required.size(), 4); ++i) {
            builder.requires(required.get(i));
        }
        builder.m_126132_(BPRecipeProvider.m_176602_((ItemLike)Index.CARPENTER_TABLE.getBlock(0)), BPRecipeProvider.m_206406_((ItemLike)Index.CARPENTER_TABLE.getBlock(0))).m_126140_(out, BA2.get(name));
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> m_176520_(MinMaxBounds.Ints p_176521_, ItemLike p_176522_) {
        return BPRecipeProvider.m_126011_(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{p_176522_}).m_151443_(p_176521_));
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> m_206406_(ItemLike p_298497_) {
        return BPRecipeProvider.m_126011_(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{p_298497_}));
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> m_125977_(TagKey<Item> p_299059_) {
        return BPRecipeProvider.m_126011_(ItemPredicate.Builder.m_45068_().m_204145_(p_299059_));
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> m_126011_(ItemPredicate.Builder ... p_299527_) {
        return BPRecipeProvider.m_293546_((ItemPredicate[])Arrays.stream(p_299527_).map(ItemPredicate.Builder::m_45077_).toArray(ItemPredicate[]::new));
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> m_293546_(ItemPredicate ... p_297226_) {
        return CriteriaTriggers.f_10571_.m_292665_((CriterionTriggerInstance)new InventoryChangeTrigger.TriggerInstance(Optional.empty(), InventoryChangeTrigger.TriggerInstance.Slots.f_303621_, List.of(p_297226_)));
    }

    public static String m_176602_(ItemLike itemLike) {
        return "has_" + BPRecipeProvider.m_176632_(itemLike);
    }

    public static String m_176632_(ItemLike itemLike) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)itemLike.m_5456_()).m_135815_();
    }
}

