/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.common.datagen;

import github.mrh0.buildersaddition2.common.BlockBlueprint;
import github.mrh0.buildersaddition2.common.datagen.BPBlockModelProvider;
import github.mrh0.buildersaddition2.common.datagen.BPBlockStateProvider;
import github.mrh0.buildersaddition2.common.datagen.BPBlockTagProvider;
import github.mrh0.buildersaddition2.common.datagen.BPItemModelProvider;
import github.mrh0.buildersaddition2.common.datagen.BPItemTagProvider;
import github.mrh0.buildersaddition2.common.datagen.BPLootTableProvider;
import github.mrh0.buildersaddition2.common.datagen.BPRecipeProvider;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;

public class BPDataGenerator {
    public static LootTableProvider createLootTableProvider(PackOutput output) {
        return new LootTableProvider(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(BPLootTableProvider::new, LootContextParamSets.f_81421_)));
    }

    public static void gatherData(String modid, GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new BPRecipeProvider(modid, packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)BPDataGenerator.createLootTableProvider(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new BPBlockStateProvider(modid, packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new BPItemModelProvider(modid, packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new BPBlockModelProvider(modid, packOutput, existingFileHelper));
        BPBlockTagProvider blockTagProvider = (BPBlockTagProvider)generator.addProvider(event.includeServer(), (DataProvider)new BPBlockTagProvider(modid, packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new BPItemTagProvider(modid, packOutput, lookupProvider, blockTagProvider.m_274426_(), existingFileHelper));
        System.out.println("==========================LANG===========================");
        BlockBlueprint.translationKeyPairs.forEach(pair -> System.out.println("\"" + (String)pair.getFirst() + "\": \"" + (String)pair.getSecond() + "\","));
        System.out.println("=========================================================");
    }
}

