/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.common;

import github.mrh0.buildersaddition2.Index;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Utils {
    public static final Direction[] HORIZONTAL_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    public static String capitalizeWords(String input) {
        String[] words = input.split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.length() <= 0) continue;
            String capitalizedWord = word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase();
            result.append(capitalizedWord).append(" ");
        }
        return result.toString().trim();
    }

    public static VoxelShape rotateBox(double x1, double y1, double z1, double x2, double y2, double z2, Direction direction) {
        double originX = 8.0;
        double originY = 8.0;
        double originZ = 8.0;
        double rotatedX1 = x1;
        double rotatedY1 = y1;
        double rotatedZ1 = z1;
        double rotatedX2 = x2;
        double rotatedY2 = y2;
        double rotatedZ2 = z2;
        switch (direction) {
            case NORTH: {
                break;
            }
            case EAST: {
                rotatedX1 = originX - (z2 - originZ);
                rotatedZ1 = originZ + (x1 - originX);
                rotatedX2 = originX - (z1 - originZ);
                rotatedZ2 = originZ + (x2 - originX);
                break;
            }
            case SOUTH: {
                rotatedX1 = originX - (x2 - originX);
                rotatedZ1 = originZ - (z2 - originZ);
                rotatedX2 = originX - (x1 - originX);
                rotatedZ2 = originZ - (z1 - originZ);
                break;
            }
            case WEST: {
                rotatedX1 = originX + (z1 - originZ);
                rotatedZ1 = originZ - (x2 - originX);
                rotatedX2 = originX + (z2 - originZ);
                rotatedZ2 = originZ - (x1 - originX);
                break;
            }
            case UP: {
                rotatedY1 = originY + (z1 - originZ);
                rotatedZ1 = originZ - (y2 - originY);
                rotatedY2 = originY + (z2 - originZ);
                rotatedZ2 = originZ - (y1 - originY);
                break;
            }
            case DOWN: {
                rotatedY1 = originY - (z2 - originZ);
                rotatedZ1 = originZ + (y1 - originY);
                rotatedY2 = originY - (z1 - originZ);
                rotatedZ2 = originZ + (y2 - originY);
            }
        }
        return Block.m_49796_((double)rotatedX1, (double)rotatedY1, (double)rotatedZ1, (double)rotatedX2, (double)rotatedY2, (double)rotatedZ2);
    }

    public static VoxelShape fromSouthFacing(VoxelShape input, Direction dir) {
        ArrayList shapes = new ArrayList();
        VoxelShape output = Shapes.m_83040_();
        input.m_83286_((x1, y1, z1, x2, y2, z2) -> shapes.add(Utils.rotateBox(x1, y1, z1, x2, y2, z2, dir)));
        for (VoxelShape shape : shapes) {
            output = Shapes.m_83110_((VoxelShape)output, (VoxelShape)shape);
        }
        return output;
    }

    public static boolean eq(BlockPos a, BlockPos b) {
        return a.m_123341_() == b.m_123341_() && a.m_123342_() == b.m_123342_() && a.m_123343_() == b.m_123343_();
    }

    public static ItemStack getIcon() {
        Block[] list = Index.COUNTER.getAllBlocks();
        Block selected = list[(int)(Math.random() * (double)list.length)];
        return new ItemStack((ItemLike)selected);
    }

    public static PaintingVariant createPainting(int w, int h) {
        return new PaintingVariant(16 * w, 16 * h);
    }

    public static boolean isntSolid(BlockState state, BlockGetter reader, BlockPos pos) {
        return false;
    }

    public static boolean isntSolid(BlockState state, BlockGetter reader, BlockPos pos, EntityType<?> ent) {
        return false;
    }

    public static boolean accessCheck(Level world, BlockPos pos, Direction facing) {
        BlockState front = world.m_8055_(pos.m_121945_(facing));
        return !front.m_60783_((BlockGetter)world, pos.m_121945_(facing), facing.m_122424_()) && !front.m_60783_((BlockGetter)world, pos.m_121945_(facing), Direction.UP);
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> p_152133_, BlockEntityType<E> p_152134_, BlockEntityTicker<? super E> p_152135_) {
        return p_152134_ == p_152133_ ? p_152135_ : null;
    }
}

