/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.common;

import com.mojang.datafixers.util.Pair;
import github.mrh0.buildersaddition2.BA2;
import github.mrh0.buildersaddition2.common.datagen.BPBlockModelProvider;
import github.mrh0.buildersaddition2.common.datagen.BPBlockStateProvider;
import github.mrh0.buildersaddition2.common.datagen.BPItemModelProvider;
import github.mrh0.buildersaddition2.common.datagen.BPLootTableProvider;
import github.mrh0.buildersaddition2.common.datagen.BPRecipeProvider;
import github.mrh0.buildersaddition2.common.variants.ResourceVariant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.registries.RegistryObject;

public abstract class BlockBlueprint<V extends ResourceVariant, B extends Block> {
    public static List<Pair<String, String>> translationKeyPairs = new ArrayList<Pair<String, String>>();
    public static List<BlockBlueprint<? extends ResourceVariant, ? extends Block>> ALL_BLUEPRINTS = new ArrayList<BlockBlueprint<? extends ResourceVariant, ? extends Block>>();
    private final List<Pair<RegistryObject<B>, V>> registryList = new ArrayList<Pair<RegistryObject<B>, V>>();

    public BlockBlueprint(Iterable<V> variants) {
        ALL_BLUEPRINTS.add(this);
        this.registerAll(variants);
    }

    protected abstract Supplier<B> getBlock(V var1);

    protected String getRegistryName(V variant) {
        return ((ResourceVariant)variant).getRegistryName(this.getBaseName());
    }

    public ResourceLocation resource(String path) {
        return new ResourceLocation("buildersaddition2", path);
    }

    public ResourceLocation resource(V variant) {
        return this.resource(this.getRegistryName(variant));
    }

    protected abstract void buildBlockState(BPBlockStateProvider var1, RegistryObject<B> var2, V var3);

    public boolean hasItem(V variant) {
        return true;
    }

    protected boolean addToCreativeTab(RegistryObject<B> block, V variant) {
        return true;
    }

    protected void onCreativeTab(BuildCreativeModeTabContentsEvent event, RegistryObject<B> block, V variant) {
        if (event.getTabKey() == BA2.MAIN_TAB.getKey() && this.addToCreativeTab(block, variant)) {
            event.m_246326_((ItemLike)block.get());
        }
    }

    protected abstract void buildBlockModel(BPBlockModelProvider var1, RegistryObject<B> var2, V var3);

    protected abstract void buildItemModel(BPItemModelProvider var1, RegistryObject<B> var2, V var3);

    public abstract String getBaseName();

    public String getBlockModelPath(V variant) {
        return "block/" + this.getRegistryName(variant);
    }

    public String getBlockModelPath(V variant, String ext) {
        return "block/" + this.getRegistryName(variant) + ext;
    }

    public List<TagKey<Block>> addBlockTags(V variant) {
        return List.of();
    }

    public String getLangKey(V variant) {
        return "block.buildersaddition2." + this.getRegistryName(variant);
    }

    public abstract String getLangName(V var1);

    public void buildLootTable(BPLootTableProvider provider, RegistryObject<B> block, V variant) {
        provider.m_245724_((Block)block.get());
    }

    public List<ItemLike> getRecipeRequired(V variant) {
        return List.of();
    }

    public int getRecipeResultCount(V variant) {
        return 1;
    }

    public void buildRecipe(BPRecipeProvider provider, RecipeOutput out, RegistryObject<B> block, V variant) {
        BPRecipeProvider.carpenter(out, this.getRegistryName(variant), (ItemLike)((Block)block.get()).m_5456_(), this.getRecipeResultCount(variant), this.getRecipeRequired(variant));
    }

    private RegistryObject<B> registerOne(V variant) {
        String name = this.getRegistryName(variant);
        RegistryObject block = BA2.BLOCKS.register(name, this.getBlock(variant));
        if (this.hasItem(variant)) {
            BA2.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        }
        translationKeyPairs.add((Pair<String, String>)Pair.of((Object)this.getLangKey(variant), (Object)this.getLangName(variant)));
        return block;
    }

    public final void registerAll(Iterable<V> iterable) {
        iterable.forEach(variant -> this.registryList.add(Pair.of(this.registerOne(variant), (Object)variant)));
    }

    public final void generateAllBlockStates(BPBlockStateProvider bsp) {
        this.registryList.forEach(pair -> this.buildBlockState(bsp, (RegistryObject)pair.getFirst(), (ResourceVariant)pair.getSecond()));
    }

    public final void generateAllBlockModels(BPBlockModelProvider provider) {
        this.registryList.forEach(pair -> this.buildBlockModel(provider, (RegistryObject)pair.getFirst(), (ResourceVariant)pair.getSecond()));
    }

    public final void generateAllItemModels(BPItemModelProvider provider) {
        this.registryList.forEach(pair -> this.buildItemModel(provider, (RegistryObject)pair.getFirst(), (ResourceVariant)pair.getSecond()));
    }

    public final void generateAllRecipes(BPRecipeProvider provider, RecipeOutput out) {
        this.registryList.forEach(pair -> this.buildRecipe(provider, out, (RegistryObject)pair.getFirst(), (ResourceVariant)pair.getSecond()));
    }

    public final void addAllToCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        this.registryList.forEach(pair -> this.onCreativeTab(event, (RegistryObject)pair.getFirst(), (ResourceVariant)pair.getSecond()));
    }

    public Iterable<Pair<RegistryObject<B>, V>> iterable() {
        return this.registryList;
    }

    public final Map<TagKey<Block>, List<Block>> getTagPairs() {
        HashMap<TagKey<Block>, List<Block>> map = new HashMap<TagKey<Block>, List<Block>>();
        this.registryList.forEach(pair -> this.addBlockTags((ResourceVariant)pair.getSecond()).forEach(key -> {
            if (map.containsKey(key)) {
                ((List)map.getOrDefault(key, new ArrayList())).add((Block)((RegistryObject)pair.getFirst()).get());
            } else {
                ArrayList<Block> list = new ArrayList<Block>();
                list.add((Block)((RegistryObject)pair.getFirst()).get());
                map.putIfAbsent((TagKey<Block>)key, (List<Block>)list);
            }
        }));
        return map;
    }

    public final ModelFile model(String model) {
        return new ModelFile.UncheckedModelFile(this.resource(model));
    }

    public final ModelFile blockModel(String model) {
        return new ModelFile.UncheckedModelFile(this.resource("block/" + model));
    }

    public final Block getBlock(int index) {
        return (Block)((RegistryObject)this.registryList.get(index).getFirst()).get();
    }

    public final int getBlockCount() {
        return this.registryList.size();
    }

    public final Block[] getAllBlocks() {
        Block[] blocks = new Block[this.registryList.size()];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = this.getBlock(i);
        }
        return blocks;
    }

    public static List<Block> getAllBlueprintBlocks() {
        ArrayList<Block> out = new ArrayList<Block>();
        ALL_BLUEPRINTS.forEach(blueprint -> blueprint.iterable().forEach(pair -> out.add((Block)((RegistryObject)pair.getFirst()).get())));
        return out;
    }
}

