/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.table;

import github.mrh0.buildersaddition2.blocks.table.TableBlock;
import github.mrh0.buildersaddition2.common.BlockBlueprint;
import github.mrh0.buildersaddition2.common.datagen.BPBlockModelProvider;
import github.mrh0.buildersaddition2.common.datagen.BPBlockStateProvider;
import github.mrh0.buildersaddition2.common.datagen.BPItemModelProvider;
import github.mrh0.buildersaddition2.common.variants.WoodVariant;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.registries.RegistryObject;

public class TableBlueprint
extends BlockBlueprint<WoodVariant, TableBlock> {
    public TableBlueprint(Iterable<WoodVariant> variants) {
        super(variants);
    }

    @Override
    public String getBaseName() {
        return "table";
    }

    @Override
    public String getLangName(WoodVariant variant) {
        return variant.getDisplayName() + " Table";
    }

    @Override
    public List<TagKey<Block>> addBlockTags(WoodVariant variant) {
        return List.of(BlockTags.f_144280_);
    }

    @Override
    protected Supplier<TableBlock> getBlock(WoodVariant variant) {
        return () -> new TableBlock(BlockBehaviour.Properties.m_308003_((BlockBehaviour)Blocks.f_50705_));
    }

    @Override
    protected void buildBlockModel(BPBlockModelProvider provider, RegistryObject<TableBlock> block, WoodVariant variant) {
        ((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant), this.resource("block/base_" + this.getBaseName())).texture("texture", variant.texturePlanks)).texture("particle", variant.texturePlanks);
        ((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant) + "_leg", this.resource("block/base_" + this.getBaseName() + "_leg")).texture("texture", variant.textureStripped)).texture("particle", variant.texturePlanks);
    }

    @Override
    protected void buildItemModel(BPItemModelProvider provider, RegistryObject<TableBlock> block, WoodVariant variant) {
        ((ItemModelBuilder)((ItemModelBuilder)provider.withParent(this.getRegistryName(variant), this.resource("block/base_" + this.getBaseName() + "_inventory")).texture("tex", variant.texturePlanks)).texture("leg", variant.textureStripped)).texture("particle", variant.texturePlanks);
    }

    @Override
    public void buildBlockState(BPBlockStateProvider provider, RegistryObject<TableBlock> block, WoodVariant variant) {
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)provider.getMultipartBuilder((Block)block.get()).part().modelFile(this.model(this.getBlockModelPath(variant))).addModel()).end().part().modelFile(this.model(this.getBlockModelPath(variant) + "_leg")).addModel()).condition((Property)TableBlock.NE, (Comparable[])new Boolean[]{true}).end().part().modelFile(this.model(this.getBlockModelPath(variant) + "_leg")).rotationY(270).addModel()).condition((Property)TableBlock.NW, (Comparable[])new Boolean[]{true}).end().part().modelFile(this.model(this.getBlockModelPath(variant) + "_leg")).rotationY(90).addModel()).condition((Property)TableBlock.SE, (Comparable[])new Boolean[]{true}).end().part().modelFile(this.model(this.getBlockModelPath(variant) + "_leg")).rotationY(180).addModel()).condition((Property)TableBlock.SW, (Comparable[])new Boolean[]{true}).end();
    }

    @Override
    public int getRecipeResultCount(WoodVariant variant) {
        return 2;
    }

    @Override
    public List<ItemLike> getRecipeRequired(WoodVariant variant) {
        return List.of(variant.slab, variant.stripped);
    }
}

