/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.support_beam;

import github.mrh0.buildersaddition2.blocks.post.PostBlock;
import github.mrh0.buildersaddition2.blocks.support_beam.SupportBeamBlock;
import github.mrh0.buildersaddition2.common.BlockBlueprint;
import github.mrh0.buildersaddition2.common.datagen.BPBlockModelProvider;
import github.mrh0.buildersaddition2.common.datagen.BPBlockStateProvider;
import github.mrh0.buildersaddition2.common.datagen.BPItemModelProvider;
import github.mrh0.buildersaddition2.common.datagen.BPLootTableProvider;
import github.mrh0.buildersaddition2.common.variants.WoodVariant;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.RegistryObject;

public class SupportBeamBlueprint
extends BlockBlueprint<WoodVariant, SupportBeamBlock> {
    public SupportBeamBlueprint(Iterable<WoodVariant> variants) {
        super(variants);
    }

    @Override
    public String getBaseName() {
        return "support_beam";
    }

    @Override
    public String getLangName(WoodVariant variant) {
        return variant.getDisplayName() + " Support Beam";
    }

    @Override
    public List<TagKey<Block>> addBlockTags(WoodVariant variant) {
        return List.of(BlockTags.f_144280_);
    }

    @Override
    protected Supplier<SupportBeamBlock> getBlock(WoodVariant variant) {
        return () -> new SupportBeamBlock(BlockBehaviour.Properties.m_308003_((BlockBehaviour)Blocks.f_50705_));
    }

    @Override
    protected void buildBlockModel(BPBlockModelProvider provider, RegistryObject<SupportBeamBlock> block, WoodVariant variant) {
        ((BlockModelBuilder)((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant) + "_xyz", this.resource("block/base_" + this.getBaseName() + "_xyz")).texture("0", variant.textureStripped)).texture("1", variant.textureStrippedTop)).texture("particle", variant.textureStripped);
        ((BlockModelBuilder)((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant) + "_y", this.resource("block/base_" + this.getBaseName() + "_y")).texture("0", variant.textureStripped)).texture("1", variant.textureStrippedTop)).texture("particle", variant.textureStripped);
        ((BlockModelBuilder)((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant) + "_yz", this.resource("block/base_" + this.getBaseName() + "_yz")).texture("0", variant.textureStripped)).texture("1", variant.textureStrippedTop)).texture("particle", variant.textureStripped);
        ((BlockModelBuilder)((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant) + "_xz", this.resource("block/base_" + this.getBaseName() + "_xz")).texture("0", variant.textureStripped)).texture("1", variant.textureStrippedTop)).texture("particle", variant.textureStripped);
        ((BlockModelBuilder)((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant) + "_z", this.resource("block/base_" + this.getBaseName() + "_z")).texture("0", variant.textureStripped)).texture("1", variant.textureStrippedTop)).texture("particle", variant.textureStripped);
    }

    @Override
    protected void buildItemModel(BPItemModelProvider provider, RegistryObject<SupportBeamBlock> block, WoodVariant variant) {
        provider.withParent(this.getRegistryName(variant), this.resource(this.getBlockModelPath(variant, "_y")));
    }

    @Override
    public void buildBlockState(BPBlockStateProvider provider, RegistryObject<SupportBeamBlock> block, WoodVariant variant) {
        Function<BlockState, ModelFile> modelFunc = state -> {
            boolean x = (Boolean)state.m_61143_((Property)SupportBeamBlock.AXIS_X);
            boolean y = (Boolean)state.m_61143_((Property)SupportBeamBlock.AXIS_Y);
            boolean z = (Boolean)state.m_61143_((Property)SupportBeamBlock.AXIS_Z);
            if (x && y && z) {
                return this.blockModel(variant + "_" + this.getBaseName() + "_xyz");
            }
            if (y && (z || x)) {
                return this.blockModel(variant + "_" + this.getBaseName() + "_yz");
            }
            if (z && x) {
                return this.blockModel(variant + "_" + this.getBaseName() + "_xz");
            }
            if (z || x) {
                return this.blockModel(variant + "_" + this.getBaseName() + "_z");
            }
            return this.blockModel(variant + "_" + this.getBaseName() + "_y");
        };
        provider.getVariantBuilder((Block)block.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY((Boolean)state.m_61143_((Property)PostBlock.AXIS_X) != false && (Boolean)state.m_61143_((Property)PostBlock.AXIS_Z) == false ? 90 : 0).uvLock(false).build(), new Property[]{BlockStateProperties.f_61362_});
    }

    @Override
    public void buildLootTable(BPLootTableProvider provider, RegistryObject<SupportBeamBlock> block, WoodVariant variant) {
        LootTable.Builder builder = LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((SupportBeamBlock)((Object)block.get())).m_5456_())).m_79080_(ExplosionCondition.m_81661_()).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)block.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)SupportBeamBlock.AXIS_X, true))));
        builder.m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((SupportBeamBlock)((Object)block.get())).m_5456_())).m_79080_(ExplosionCondition.m_81661_()).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)block.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)SupportBeamBlock.AXIS_Y, true))));
        builder.m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((SupportBeamBlock)((Object)block.get())).m_5456_())).m_79080_(ExplosionCondition.m_81661_()).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)block.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)SupportBeamBlock.AXIS_Z, true))));
        provider.m_247577_((Block)block.get(), builder);
    }

    @Override
    public int getRecipeResultCount(WoodVariant variant) {
        return 2;
    }

    @Override
    public List<ItemLike> getRecipeRequired(WoodVariant variant) {
        return List.of(variant.stripped);
    }
}

