/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.stripped_fence;

import github.mrh0.buildersaddition2.blocks.stripped_fence.StrippedFenceBlock;
import github.mrh0.buildersaddition2.common.BlockBlueprint;
import github.mrh0.buildersaddition2.common.datagen.BPBlockModelProvider;
import github.mrh0.buildersaddition2.common.datagen.BPBlockStateProvider;
import github.mrh0.buildersaddition2.common.datagen.BPItemModelProvider;
import github.mrh0.buildersaddition2.common.variants.WoodVariant;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.registries.RegistryObject;

public class StrippedFenceBlueprint
extends BlockBlueprint<WoodVariant, StrippedFenceBlock> {
    public StrippedFenceBlueprint(Iterable<WoodVariant> variants) {
        super(variants);
    }

    @Override
    protected Supplier<StrippedFenceBlock> getBlock(WoodVariant variant) {
        return () -> new StrippedFenceBlock(BlockBehaviour.Properties.m_308003_((BlockBehaviour)variant.planks));
    }

    @Override
    public List<TagKey<Block>> addBlockTags(WoodVariant variant) {
        return List.of(BlockTags.f_144280_, BlockTags.f_13039_, BlockTags.f_13098_);
    }

    @Override
    public String getBaseName() {
        return "stripped_fence";
    }

    @Override
    public String getLangName(WoodVariant variant) {
        return "Stripped " + variant.getDisplayName() + " Fence";
    }

    @Override
    protected void buildBlockState(BPBlockStateProvider bsp, RegistryObject<StrippedFenceBlock> block, WoodVariant variant) {
        bsp.fenceBlock((FenceBlock)block.get(), new ResourceLocation(variant.textureStripped));
    }

    @Override
    protected void buildBlockModel(BPBlockModelProvider provider, RegistryObject<StrippedFenceBlock> block, WoodVariant variant) {
        ((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant, "_post"), this.resource("block/base_" + this.getBaseName() + "_post")).texture("texture", variant.textureStripped)).texture("particle", variant.textureStripped);
        ((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant, "_side"), this.resource("block/base_" + this.getBaseName() + "_side")).texture("texture", variant.texturePlanks)).texture("particle", variant.textureStripped);
    }

    @Override
    protected void buildItemModel(BPItemModelProvider provider, RegistryObject<StrippedFenceBlock> block, WoodVariant variant) {
        provider.withParent(this.getRegistryName(variant), this.resource("block/base_" + this.getBaseName() + "_inventory")).texture("texture", variant.textureStripped);
    }

    @Override
    public int getRecipeResultCount(WoodVariant variant) {
        return 4;
    }

    @Override
    public List<ItemLike> getRecipeRequired(WoodVariant variant) {
        return List.of(variant.stripped, variant.planks);
    }
}

