/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.sofa;

import github.mrh0.buildersaddition2.blocks.base.ISeatBlock;
import github.mrh0.buildersaddition2.entity.seat.SeatEntity;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SofaBlock
extends Block
implements ISeatBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.f_61398_;
    public static final BooleanProperty ARMREST_LEFT = BooleanProperty.m_61465_((String)"armrest_left");
    public static final BooleanProperty ARMREST_RIGHT = BooleanProperty.m_61465_((String)"armrest_right");
    private static VoxelShape BASE_SHAPE = Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    private static VoxelShape BACK_SHAPE = Block.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
    private final Map<BlockState, VoxelShape> shapesCache = this.m_152458_(SofaBlock::buildShape);

    public SofaBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SHAPE, ARMREST_LEFT, ARMREST_RIGHT});
    }

    private static boolean isSofa(BlockState state) {
        return state.m_60734_() instanceof SofaBlock;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        BlockState blockstate = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)(context.m_7078_() ? context.m_8125_().m_122424_() : context.m_8125_()));
        blockstate = (BlockState)blockstate.m_61124_(SHAPE, (Comparable)SofaBlock.getStairsShape(blockstate, (BlockGetter)context.m_43725_(), blockpos));
        return (BlockState)((BlockState)blockstate.m_61124_((Property)ARMREST_LEFT, (Comparable)Boolean.valueOf(SofaBlock.hasArmrestLeft(blockstate, (BlockGetter)context.m_43725_(), blockpos)))).m_61124_((Property)ARMREST_RIGHT, (Comparable)Boolean.valueOf(SofaBlock.hasArmrestRight(blockstate, (BlockGetter)context.m_43725_(), blockpos)));
    }

    public BlockState m_7417_(BlockState myState, Direction direction, BlockState otherState, LevelAccessor level, BlockPos myPos, BlockPos otherPos) {
        if (!direction.m_122434_().m_122479_()) {
            return super.m_7417_(myState, direction, otherState, level, myPos, otherPos);
        }
        BlockState newState = (BlockState)myState.m_61124_(SHAPE, (Comparable)SofaBlock.getStairsShape(myState, (BlockGetter)level, myPos));
        return (BlockState)((BlockState)newState.m_61124_((Property)ARMREST_LEFT, (Comparable)Boolean.valueOf(SofaBlock.hasArmrestLeft(newState, (BlockGetter)level, myPos)))).m_61124_((Property)ARMREST_RIGHT, (Comparable)Boolean.valueOf(SofaBlock.hasArmrestRight(newState, (BlockGetter)level, myPos)));
    }

    private static StairsShape getStairsShape(BlockState state, BlockGetter getter, BlockPos pos) {
        Direction direction2;
        Direction otherDirection;
        Direction forward = (Direction)state.m_61143_((Property)FACING);
        BlockState blockstate = getter.m_8055_(pos.m_121945_(forward));
        if (SofaBlock.isSofa(blockstate) && (otherDirection = (Direction)blockstate.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_() && SofaBlock.canTakeShape(state, getter, pos, otherDirection.m_122424_())) {
            if (otherDirection == forward.m_122428_()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState backward = getter.m_8055_(pos.m_121945_(forward.m_122424_()));
        if (SofaBlock.isSofa(backward) && (direction2 = (Direction)backward.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_() && SofaBlock.canTakeShape(state, getter, pos, direction2)) {
            if (direction2 == forward.m_122428_()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    public static boolean hasArmrestLeft(BlockState myState, BlockGetter getter, BlockPos pos) {
        if (myState.m_61143_(SHAPE) != StairsShape.STRAIGHT) {
            return false;
        }
        BlockState state = getter.m_8055_(pos.m_121945_(((Direction)myState.m_61143_((Property)FACING)).m_122428_()));
        return !SofaBlock.isSofa(state);
    }

    public static boolean hasArmrestRight(BlockState myState, BlockGetter getter, BlockPos pos) {
        if (myState.m_61143_(SHAPE) != StairsShape.STRAIGHT) {
            return false;
        }
        BlockState state = getter.m_8055_(pos.m_121945_(((Direction)myState.m_61143_((Property)FACING)).m_122427_()));
        return !SofaBlock.isSofa(state);
    }

    private static boolean canTakeShape(BlockState state, BlockGetter getter, BlockPos pos, Direction direction) {
        BlockState blockstate = getter.m_8055_(pos.m_121945_(direction));
        return !SofaBlock.isSofa(blockstate) || blockstate.m_61143_((Property)FACING) != state.m_61143_((Property)FACING);
    }

    private static VoxelShape buildShape(BlockState state) {
        return BASE_SHAPE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext col) {
        return BASE_SHAPE;
    }

    public void m_5548_(BlockGetter level, Entity entityIn) {
        if (entityIn.m_20162_()) {
            super.m_5548_(level, entityIn);
        } else {
            this.bounceUp(entityIn);
        }
    }

    private void bounceUp(Entity entity) {
        Vec3 vector3d = entity.m_20184_();
        if (vector3d.f_82480_ < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.m_20334_(vector3d.f_82479_, -vector3d.f_82480_ * (double)0.66f * d0, vector3d.f_82481_);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return SeatEntity.createSeat(world, pos, (LivingEntity)player, 0.45, SoundEvents.f_12641_);
    }
}

