/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.shop_sign;

import github.mrh0.buildersaddition2.blocks.blockstate.ShopSignState;
import github.mrh0.buildersaddition2.blocks.shop_sign.ShopSignBlock;
import github.mrh0.buildersaddition2.common.BlockBlueprint;
import github.mrh0.buildersaddition2.common.datagen.BPBlockModelProvider;
import github.mrh0.buildersaddition2.common.datagen.BPBlockStateProvider;
import github.mrh0.buildersaddition2.common.datagen.BPItemModelProvider;
import github.mrh0.buildersaddition2.common.variants.WoodVariant;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.registries.RegistryObject;

public class ShopSignBlueprint
extends BlockBlueprint<WoodVariant, ShopSignBlock> {
    public ShopSignBlueprint(Iterable<WoodVariant> variants) {
        super(variants);
    }

    @Override
    public String getBaseName() {
        return "shop_sign";
    }

    @Override
    public String getLangName(WoodVariant variant) {
        return variant.getDisplayName() + " Shop Sign";
    }

    @Override
    public List<TagKey<Block>> addBlockTags(WoodVariant variant) {
        return List.of(BlockTags.f_144280_);
    }

    @Override
    protected Supplier<ShopSignBlock> getBlock(WoodVariant variant) {
        return () -> new ShopSignBlock(BlockBehaviour.Properties.m_308003_((BlockBehaviour)Blocks.f_50705_));
    }

    @Override
    protected void buildBlockModel(BPBlockModelProvider provider, RegistryObject<ShopSignBlock> block, WoodVariant variant) {
        ((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant), this.resource("block/base_" + this.getBaseName())).texture("texture", variant.textureStripped)).texture("particle", variant.textureStripped);
        ((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant, "_hanging"), this.resource("block/base_" + this.getBaseName() + "_hanging")).texture("texture", variant.textureStripped)).texture("particle", variant.textureStripped);
    }

    @Override
    protected void buildItemModel(BPItemModelProvider provider, RegistryObject<ShopSignBlock> block, WoodVariant variant) {
        provider.withParent(this.getRegistryName(variant), this.resource(this.getBlockModelPath(variant)));
    }

    @Override
    public void buildBlockState(BPBlockStateProvider provider, RegistryObject<ShopSignBlock> block, WoodVariant variant) {
        provider.getVariantBuilder((Block)block.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile(((ShopSignState)((Object)((Object)state.m_61143_(ShopSignBlock.TYPE)))).isHorizontal() ? this.blockModel(variant + "_shop_sign") : this.blockModel(variant + "_shop_sign_hanging")).rotationX(((ShopSignState)((Object)((Object)state.m_61143_(ShopSignBlock.TYPE)))).toXRot() % 360).rotationY(((ShopSignState)((Object)((Object)state.m_61143_(ShopSignBlock.TYPE)))).toYRot() % 360).uvLock(true).build(), new Property[]{BlockStateProperties.f_61362_});
    }

    @Override
    public int getRecipeResultCount(WoodVariant variant) {
        return 2;
    }

    @Override
    public List<ItemLike> getRecipeRequired(WoodVariant variant) {
        return List.of(variant.stripped, Items.f_42416_);
    }
}

