/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.shelf;

import com.mojang.serialization.MapCodec;
import github.mrh0.buildersaddition2.blocks.base.AbstractStorageBlock;
import github.mrh0.buildersaddition2.blocks.base.AbstractStorageBlockEntity;
import github.mrh0.buildersaddition2.blocks.shelf.ShelfBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.extensions.IForgeServerPlayer;
import org.jetbrains.annotations.Nullable;

public class ShelfBlock
extends AbstractStorageBlock {
    public static final MapCodec<ShelfBlock> CODEC = ShelfBlock.m_306223_(ShelfBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    protected static final VoxelShape NORTH_SHAPE_BOTTOM = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)8.0);
    protected static final VoxelShape EAST_SHAPE_BOTTOM = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE_BOTTOM = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape WEST_SHAPE_BOTTOM = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)2.0, (double)16.0);
    protected static final VoxelShape NORTH_SHAPE_TOP = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)10.0, (double)8.0);
    protected static final VoxelShape EAST_SHAPE_TOP = Block.m_49796_((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE_TOP = Block.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)10.0, (double)16.0);
    protected static final VoxelShape WEST_SHAPE_TOP = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)10.0, (double)16.0);

    public ShelfBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    protected MapCodec<? extends BaseEntityBlock> m_304657_() {
        return CODEC;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext c) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)c.m_8125_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext c) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.EAST -> Shapes.m_83110_((VoxelShape)EAST_SHAPE_BOTTOM, (VoxelShape)EAST_SHAPE_TOP);
            case Direction.SOUTH -> Shapes.m_83110_((VoxelShape)SOUTH_SHAPE_BOTTOM, (VoxelShape)SOUTH_SHAPE_TOP);
            case Direction.WEST -> Shapes.m_83110_((VoxelShape)WEST_SHAPE_BOTTOM, (VoxelShape)WEST_SHAPE_TOP);
            default -> Shapes.m_83110_((VoxelShape)NORTH_SHAPE_BOTTOM, (VoxelShape)NORTH_SHAPE_TOP);
        };
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AbstractStorageBlockEntity) {
            AbstractStorageBlockEntity be = (AbstractStorageBlockEntity)blockEntity;
            if (!(player instanceof IForgeServerPlayer)) {
                return InteractionResult.SUCCESS;
            }
            IForgeServerPlayer fsp = (IForgeServerPlayer)player;
            fsp.openMenu((MenuProvider)be, extraData -> extraData.m_130064_(pos));
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ShelfBlockEntity(pos, state);
    }
}

