/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.pillow;

import github.mrh0.buildersaddition2.blocks.pillow.PillowBlock;
import github.mrh0.buildersaddition2.common.BlockBlueprint;
import github.mrh0.buildersaddition2.common.datagen.BPBlockModelProvider;
import github.mrh0.buildersaddition2.common.datagen.BPBlockStateProvider;
import github.mrh0.buildersaddition2.common.datagen.BPItemModelProvider;
import github.mrh0.buildersaddition2.common.variants.WoolVariant;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.registries.RegistryObject;

public class PillowBlueprint
extends BlockBlueprint<WoolVariant, PillowBlock> {
    public PillowBlueprint(Iterable<WoolVariant> variants) {
        super(variants);
    }

    @Override
    protected Supplier<PillowBlock> getBlock(WoolVariant variant) {
        return () -> new PillowBlock(BlockBehaviour.Properties.m_308003_((BlockBehaviour)Blocks.f_50041_));
    }

    @Override
    public String getBaseName() {
        return "pillow";
    }

    @Override
    public String getLangName(WoolVariant variant) {
        return variant.getDisplayName() + " Pillow";
    }

    @Override
    public List<TagKey<Block>> addBlockTags(WoolVariant variant) {
        return List.of(BlockTags.f_144280_);
    }

    @Override
    protected void buildBlockState(BPBlockStateProvider bsp, RegistryObject<PillowBlock> block, WoolVariant variant) {
        bsp.simpleBlock((Block)block.get(), this.model(this.getBlockModelPath(variant)));
    }

    @Override
    protected void buildBlockModel(BPBlockModelProvider provider, RegistryObject<PillowBlock> block, WoolVariant variant) {
        ((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant), this.resource("block/base_" + this.getBaseName())).texture("wool", variant.textureWool)).texture("particle", variant.textureWool);
        ((BlockModelBuilder)provider.withParent("block/" + variant + "_stool_pillow", this.resource("block/base_stool_" + this.getBaseName())).texture("wool", variant.textureWool)).texture("particle", variant.textureWool);
    }

    @Override
    protected void buildItemModel(BPItemModelProvider provider, RegistryObject<PillowBlock> block, WoolVariant variant) {
        provider.withParent(this.getRegistryName(variant), this.resource(this.getBlockModelPath(variant)));
    }

    @Override
    public int getRecipeResultCount(WoolVariant variant) {
        return 3;
    }

    @Override
    public List<ItemLike> getRecipeRequired(WoolVariant variant) {
        return List.of(variant.wool);
    }
}

