/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.panel;

import github.mrh0.buildersaddition2.blocks.blockstate.PanelState;
import github.mrh0.buildersaddition2.blocks.panel.PanelBlock;
import github.mrh0.buildersaddition2.common.BlockBlueprint;
import github.mrh0.buildersaddition2.common.datagen.BPBlockModelProvider;
import github.mrh0.buildersaddition2.common.datagen.BPBlockStateProvider;
import github.mrh0.buildersaddition2.common.datagen.BPItemModelProvider;
import github.mrh0.buildersaddition2.common.datagen.BPLootTableProvider;
import github.mrh0.buildersaddition2.common.variants.WoodVariant;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.RegistryObject;

public class PanelBlueprint
extends BlockBlueprint<WoodVariant, PanelBlock> {
    public PanelBlueprint(Iterable<WoodVariant> variants) {
        super(variants);
    }

    @Override
    public String getBaseName() {
        return "panel";
    }

    @Override
    public String getLangName(WoodVariant variant) {
        return variant.getDisplayName() + " Panel";
    }

    @Override
    public List<TagKey<Block>> addBlockTags(WoodVariant variant) {
        return List.of(BlockTags.f_144280_);
    }

    @Override
    protected Supplier<PanelBlock> getBlock(WoodVariant variant) {
        return () -> new PanelBlock(BlockBehaviour.Properties.m_308003_((BlockBehaviour)Blocks.f_50705_));
    }

    @Override
    protected void buildBlockModel(BPBlockModelProvider provider, RegistryObject<PanelBlock> block, WoodVariant variant) {
        ((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant), this.resource("block/base_" + this.getBaseName())).texture("texture", variant.texturePlanks)).texture("particle", variant.texturePlanks);
        ((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant) + "_double", this.resource("block/base_" + this.getBaseName() + "_double")).texture("all", variant.texturePlanks)).texture("particle", variant.texturePlanks);
    }

    @Override
    protected void buildItemModel(BPItemModelProvider provider, RegistryObject<PanelBlock> block, WoodVariant variant) {
        provider.withParent(this.getRegistryName(variant), this.resource(this.getBlockModelPath(variant)));
    }

    @Override
    public void buildBlockState(BPBlockStateProvider provider, RegistryObject<PanelBlock> block, WoodVariant variant) {
        Function<BlockState, ModelFile> modelFunc = state -> switch ((PanelState)((Object)((Object)state.m_61143_(PanelBlock.SHAPE)))) {
            case PanelState.DOUBLE_X, PanelState.DOUBLE_Z -> this.blockModel(variant + "_panel_double");
            default -> this.blockModel(variant + "_panel");
        };
        provider.getVariantBuilder((Block)block.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY(((int)((PanelState)((Object)((Object)state.m_61143_(PanelBlock.SHAPE)))).toYRot() + 180) % 360).uvLock(true).build(), new Property[]{BlockStateProperties.f_61362_});
    }

    @Override
    public void buildLootTable(BPLootTableProvider provider, RegistryObject<PanelBlock> block, WoodVariant variant) {
        LootTable.Builder builder = LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((PanelBlock)((Object)block.get())).m_5456_())).m_79080_(ExplosionCondition.m_81661_()));
        builder.m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((PanelBlock)((Object)block.get())).m_5456_())).m_79080_(ExplosionCondition.m_81661_()).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)block.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(PanelBlock.SHAPE, (Comparable)((Object)PanelState.DOUBLE_X)))));
        builder.m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((PanelBlock)((Object)block.get())).m_5456_())).m_79080_(ExplosionCondition.m_81661_()).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)block.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(PanelBlock.SHAPE, (Comparable)((Object)PanelState.DOUBLE_Z)))));
        provider.m_247577_((Block)block.get(), builder);
    }

    @Override
    public int getRecipeResultCount(WoodVariant variant) {
        return 2;
    }

    @Override
    public List<ItemLike> getRecipeRequired(WoodVariant variant) {
        return List.of(variant.planks);
    }
}

