/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.panel;

import github.mrh0.buildersaddition2.blocks.blockstate.PanelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PanelBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<PanelState> SHAPE = EnumProperty.m_61587_((String)"shape", PanelState.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape WEST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);

    public PanelBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(SHAPE, (Comparable)((Object)PanelState.NORTH))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SHAPE, WATERLOGGED});
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return this.m_6843_(state, mirror.m_54846_(((PanelState)((Object)state.m_61143_(SHAPE))).getFacing()));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)PanelState.reverseFacing(rotation.m_55954_(((PanelState)((Object)state.m_61143_(SHAPE))).getFacing()), ((PanelState)((Object)state.m_61143_(SHAPE))).isDouble())));
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation direction) {
        return this.m_6843_(state, direction);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((PanelState)((Object)state.m_61143_(SHAPE))) {
            case PanelState.DOUBLE_X, PanelState.DOUBLE_Z -> Shapes.m_83144_();
            case PanelState.EAST -> EAST_SHAPE;
            case PanelState.SOUTH -> SOUTH_SHAPE;
            case PanelState.WEST -> WEST_SHAPE;
            default -> NORTH_SHAPE;
        };
    }

    public boolean isTransparent(BlockState state) {
        return !((PanelState)((Object)state.m_61143_(SHAPE))).isDouble();
    }

    private PanelState getDoubleState(PanelState s) {
        if (s == PanelState.EAST || s == PanelState.WEST) {
            return PanelState.DOUBLE_X;
        }
        return PanelState.DOUBLE_Z;
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext c) {
        BlockPos blockpos = c.m_8083_();
        BlockState blockstate = c.m_43725_().m_8055_(blockpos);
        if (blockstate.m_60734_() == this) {
            return (BlockState)((BlockState)blockstate.m_61124_(SHAPE, (Comparable)((Object)this.getDoubleState((PanelState)((Object)blockstate.m_61143_(SHAPE)))))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE);
        }
        FluidState fluidState = c.m_43725_().m_6425_(blockpos);
        BlockState blockState = (BlockState)((BlockState)this.m_49966_().m_61124_(SHAPE, (Comparable)((Object)PanelState.NORTH))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        Direction face = c.m_43719_();
        double flagX = c.m_43720_().f_82479_ - (double)c.m_8083_().m_123341_() - 0.5;
        double flagZ = c.m_43720_().f_82481_ - (double)c.m_8083_().m_123343_() - 0.5;
        PanelState vss = PanelState.forFacings(face, c.m_8125_());
        if (flagZ > 0.0 && this.diffG(flagZ, flagX)) {
            vss = PanelState.SOUTH;
        }
        if (flagZ < 0.0 && this.diffG(flagZ, flagX)) {
            vss = PanelState.NORTH;
        }
        if (flagX > 0.0 && this.diffG(flagX, flagZ)) {
            vss = PanelState.EAST;
        }
        if (flagX < 0.0 && this.diffG(flagX, flagZ)) {
            vss = PanelState.WEST;
        }
        return (BlockState)blockState.m_61124_(SHAPE, (Comparable)((Object)vss));
    }

    private boolean diffG(double d1, double d2) {
        return Math.abs(d1) > Math.abs(d2);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext c) {
        ItemStack itemstack = c.m_43722_();
        PanelState panelShape = (PanelState)((Object)state.m_61143_(SHAPE));
        if (panelShape != PanelState.DOUBLE_X && panelShape != PanelState.DOUBLE_Z && itemstack.m_41720_() == this.m_5456_()) {
            if (!c.m_7058_()) {
                return true;
            }
            if (c.m_43719_() == Direction.NORTH && panelShape == PanelState.SOUTH) {
                return true;
            }
            if (c.m_43719_() == Direction.EAST && panelShape == PanelState.WEST) {
                return true;
            }
            if (c.m_43719_() == Direction.SOUTH && panelShape == PanelState.NORTH) {
                return true;
            }
            return c.m_43719_() == Direction.WEST && panelShape == PanelState.EAST;
        }
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return state.m_61143_(SHAPE) != PanelState.DOUBLE_X && state.m_61143_(SHAPE) != PanelState.DOUBLE_Z && super.m_7361_(level, pos, state, fluidStateIn);
    }

    public boolean m_6044_(@Nullable Player p_298313_, BlockGetter p_56301_, BlockPos p_56302_, BlockState p_56303_, Fluid p_56304_) {
        return super.m_6044_(p_298313_, p_56301_, p_56302_, p_56303_, p_56304_);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return stateIn;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        if (type == PathComputationType.WATER) {
            return level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        }
        return false;
    }
}

