/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.hedge;

import github.mrh0.buildersaddition2.blocks.blockstate.HedgeState;
import github.mrh0.buildersaddition2.blocks.hedge.HedgeBlock;
import github.mrh0.buildersaddition2.common.BlockBlueprint;
import github.mrh0.buildersaddition2.common.datagen.BPBlockModelProvider;
import github.mrh0.buildersaddition2.common.datagen.BPBlockStateProvider;
import github.mrh0.buildersaddition2.common.datagen.BPItemModelProvider;
import github.mrh0.buildersaddition2.common.variants.LeavesVariant;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.registries.RegistryObject;

public class HedgeBlueprint
extends BlockBlueprint<LeavesVariant, HedgeBlock> {
    public HedgeBlueprint(Iterable<LeavesVariant> variants) {
        super(variants);
    }

    @Override
    protected Supplier<HedgeBlock> getBlock(LeavesVariant variant) {
        return () -> new HedgeBlock(BlockBehaviour.Properties.m_308003_((BlockBehaviour)variant.leaves));
    }

    @Override
    public String getBaseName() {
        return "hedge";
    }

    @Override
    public String getLangName(LeavesVariant variant) {
        return variant.getDisplayName() + " Hedge";
    }

    @Override
    public List<TagKey<Block>> addBlockTags(LeavesVariant variant) {
        return List.of(BlockTags.f_144280_, BlockTags.f_13035_);
    }

    @Override
    protected void buildBlockState(BPBlockStateProvider bsp, RegistryObject<HedgeBlock> block, LeavesVariant variant) {
        bsp.getVariantBuilder((Block)block.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile(this.model(this.getBlockModelPath(variant, "_" + ((HedgeState)((Object)((Object)state.m_61143_(HedgeBlock.STATE)))).getModelName()))).rotationY(((HedgeState)((Object)((Object)state.m_61143_(HedgeBlock.STATE)))).getModelYRotation()).uvLock(true).build(), new Property[]{HedgeBlock.WATERLOGGED});
    }

    @Override
    protected void buildBlockModel(BPBlockModelProvider provider, RegistryObject<HedgeBlock> block, LeavesVariant variant) {
        ((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant, "_corner"), this.resource("block/base_" + this.getBaseName() + "_corner")).texture("leaves", variant.textureLeaves)).texture("particles", variant.textureLeaves);
        ((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant, "_cross"), this.resource("block/base_" + this.getBaseName() + "_cross")).texture("leaves", variant.textureLeaves)).texture("particles", variant.textureLeaves);
        ((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant, "_none"), this.resource("block/base_" + this.getBaseName() + "_none")).texture("leaves", variant.textureLeaves)).texture("particles", variant.textureLeaves);
        ((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant, "_straight"), this.resource("block/base_" + this.getBaseName() + "_straight")).texture("leaves", variant.textureLeaves)).texture("particles", variant.textureLeaves);
        ((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant, "_tcross"), this.resource("block/base_" + this.getBaseName() + "_tcross")).texture("leaves", variant.textureLeaves)).texture("particles", variant.textureLeaves);
    }

    @Override
    protected void buildItemModel(BPItemModelProvider provider, RegistryObject<HedgeBlock> block, LeavesVariant variant) {
        provider.withParent(this.getRegistryName(variant), this.resource("block/base_" + this.getBaseName() + "_inventory")).texture("leaves", variant.textureLeaves);
    }

    @Override
    public int getRecipeResultCount(LeavesVariant variant) {
        return 2;
    }

    @Override
    public List<ItemLike> getRecipeRequired(LeavesVariant variant) {
        return List.of(variant.leaves);
    }
}

