/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.hedge;

import github.mrh0.buildersaddition2.blocks.blockstate.HedgeState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IForgeShearable;
import org.jetbrains.annotations.Nullable;

public class HedgeBlock
extends Block
implements SimpleWaterloggedBlock,
IForgeShearable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<HedgeState> STATE = EnumProperty.m_61587_((String)"state", HedgeState.class);
    private static VoxelShape SHAPE_NONE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static VoxelShape SHAPE_STRAIGHT_Z = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private static VoxelShape SHAPE_STRAIGHT_X = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    private static VoxelShape SHAPE_SHORT_N = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0);
    private static VoxelShape SHAPE_SHORT_E = Block.m_49796_((double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private static VoxelShape SHAPE_SHORT_S = Block.m_49796_((double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0, (double)16.0);
    private static VoxelShape SHAPE_SHORT_W = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0);
    private static VoxelShape SHAPE_CORNER_NE = Shapes.m_83124_((VoxelShape)SHAPE_NONE, (VoxelShape[])new VoxelShape[]{SHAPE_SHORT_N, SHAPE_SHORT_E});
    private static VoxelShape SHAPE_CORNER_NW = Shapes.m_83124_((VoxelShape)SHAPE_NONE, (VoxelShape[])new VoxelShape[]{SHAPE_SHORT_N, SHAPE_SHORT_W});
    private static VoxelShape SHAPE_CORNER_SE = Shapes.m_83124_((VoxelShape)SHAPE_NONE, (VoxelShape[])new VoxelShape[]{SHAPE_SHORT_S, SHAPE_SHORT_E});
    private static VoxelShape SHAPE_CORNER_SW = Shapes.m_83124_((VoxelShape)SHAPE_NONE, (VoxelShape[])new VoxelShape[]{SHAPE_SHORT_S, SHAPE_SHORT_W});
    private static VoxelShape SHAPE_T_N = Shapes.m_83110_((VoxelShape)SHAPE_STRAIGHT_Z, (VoxelShape)SHAPE_SHORT_N);
    private static VoxelShape SHAPE_T_E = Shapes.m_83110_((VoxelShape)SHAPE_STRAIGHT_X, (VoxelShape)SHAPE_SHORT_E);
    private static VoxelShape SHAPE_T_S = Shapes.m_83110_((VoxelShape)SHAPE_STRAIGHT_Z, (VoxelShape)SHAPE_SHORT_S);
    private static VoxelShape SHAPE_T_W = Shapes.m_83110_((VoxelShape)SHAPE_STRAIGHT_X, (VoxelShape)SHAPE_SHORT_W);
    private static VoxelShape SHAPE_CROSS = Shapes.m_83110_((VoxelShape)SHAPE_STRAIGHT_X, (VoxelShape)SHAPE_STRAIGHT_Z);
    private static VoxelShape COL_NONE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)24.0, (double)12.0);
    private static VoxelShape COL_STRAIGHT_Z = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)24.0, (double)12.0);
    private static VoxelShape COL_STRAIGHT_X = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)24.0, (double)16.0);
    private static VoxelShape COL_SHORT_N = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)24.0, (double)4.0);
    private static VoxelShape COL_SHORT_E = Block.m_49796_((double)12.0, (double)0.0, (double)4.0, (double)16.0, (double)24.0, (double)12.0);
    private static VoxelShape COL_SHORT_S = Block.m_49796_((double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)24.0, (double)16.0);
    private static VoxelShape COL_SHORT_W = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)24.0, (double)12.0);
    private static VoxelShape COL_CORNER_NE = Shapes.m_83124_((VoxelShape)COL_NONE, (VoxelShape[])new VoxelShape[]{COL_SHORT_N, COL_SHORT_E});
    private static VoxelShape COL_CORNER_NW = Shapes.m_83124_((VoxelShape)COL_NONE, (VoxelShape[])new VoxelShape[]{COL_SHORT_N, COL_SHORT_W});
    private static VoxelShape COL_CORNER_SE = Shapes.m_83124_((VoxelShape)COL_NONE, (VoxelShape[])new VoxelShape[]{COL_SHORT_S, COL_SHORT_E});
    private static VoxelShape COL_CORNER_SW = Shapes.m_83124_((VoxelShape)COL_NONE, (VoxelShape[])new VoxelShape[]{COL_SHORT_S, COL_SHORT_W});
    private static VoxelShape COL_T_N = Shapes.m_83110_((VoxelShape)COL_STRAIGHT_Z, (VoxelShape)COL_SHORT_N);
    private static VoxelShape COL_T_E = Shapes.m_83110_((VoxelShape)COL_STRAIGHT_X, (VoxelShape)COL_SHORT_E);
    private static VoxelShape COL_T_S = Shapes.m_83110_((VoxelShape)COL_STRAIGHT_Z, (VoxelShape)COL_SHORT_S);
    private static VoxelShape COL_T_W = Shapes.m_83110_((VoxelShape)COL_STRAIGHT_X, (VoxelShape)COL_SHORT_W);
    private static VoxelShape COL_CROSS = Shapes.m_83110_((VoxelShape)COL_STRAIGHT_X, (VoxelShape)COL_STRAIGHT_Z);

    public HedgeBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(STATE, (Comparable)((Object)HedgeState.NONE)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STATE, WATERLOGGED});
    }

    public boolean isShearable(ItemStack item, Level level, BlockPos pos) {
        return true;
    }

    public VoxelShape getShape(BlockState state) {
        return switch ((HedgeState)((Object)state.m_61143_(STATE))) {
            default -> throw new IncompatibleClassChangeError();
            case HedgeState.NONE -> SHAPE_NONE;
            case HedgeState.S_X -> SHAPE_STRAIGHT_X;
            case HedgeState.S_Z -> SHAPE_STRAIGHT_Z;
            case HedgeState.C_NE -> SHAPE_CORNER_NE;
            case HedgeState.C_NW -> SHAPE_CORNER_NW;
            case HedgeState.C_SE -> SHAPE_CORNER_SE;
            case HedgeState.C_SW -> SHAPE_CORNER_SW;
            case HedgeState.T_N -> SHAPE_T_N;
            case HedgeState.T_E -> SHAPE_T_E;
            case HedgeState.T_S -> SHAPE_T_S;
            case HedgeState.T_W -> SHAPE_T_W;
            case HedgeState.C -> SHAPE_CROSS;
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((HedgeState)((Object)state.m_61143_(STATE))) {
            default -> throw new IncompatibleClassChangeError();
            case HedgeState.NONE -> COL_NONE;
            case HedgeState.S_X -> COL_STRAIGHT_X;
            case HedgeState.S_Z -> COL_STRAIGHT_Z;
            case HedgeState.C_NE -> COL_CORNER_NE;
            case HedgeState.C_NW -> COL_CORNER_NW;
            case HedgeState.C_SE -> COL_CORNER_SE;
            case HedgeState.C_SW -> COL_CORNER_SW;
            case HedgeState.T_N -> COL_T_N;
            case HedgeState.T_E -> COL_T_E;
            case HedgeState.T_S -> COL_T_S;
            case HedgeState.T_W -> COL_T_W;
            case HedgeState.C -> COL_CROSS;
        };
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getShape(state);
    }

    public BlockState getState(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState bn = level.m_8055_(pos.m_122012_());
        BlockState be = level.m_8055_(pos.m_122029_());
        BlockState bs = level.m_8055_(pos.m_122019_());
        BlockState bw = level.m_8055_(pos.m_122024_());
        boolean n = bn.m_60734_() instanceof HedgeBlock;
        boolean e = be.m_60734_() instanceof HedgeBlock;
        boolean s = bs.m_60734_() instanceof HedgeBlock;
        boolean w = bw.m_60734_() instanceof HedgeBlock;
        if (n && e && s && w) {
            return this.getNextState(state, HedgeState.C);
        }
        if (!(n || e || s || w)) {
            return this.getNextState(state, HedgeState.NONE);
        }
        if (n && e && !s && w) {
            return this.getNextState(state, HedgeState.T_N);
        }
        if (n && e && s) {
            return this.getNextState(state, HedgeState.T_E);
        }
        if (!n && e && s && w) {
            return this.getNextState(state, HedgeState.T_S);
        }
        if (n && !e && s && w) {
            return this.getNextState(state, HedgeState.T_W);
        }
        if (!e && !w) {
            return this.getNextState(state, HedgeState.S_X);
        }
        if (!n && !s) {
            return this.getNextState(state, HedgeState.S_Z);
        }
        if (n && e) {
            return this.getNextState(state, HedgeState.C_NE);
        }
        if (n) {
            return this.getNextState(state, HedgeState.C_NW);
        }
        if (e) {
            return this.getNextState(state, HedgeState.C_SE);
        }
        return this.getNextState(state, HedgeState.C_SW);
    }

    private BlockState getNextState(BlockState state, HedgeState shape) {
        return (BlockState)state.m_61124_(STATE, (Comparable)((Object)shape));
    }

    public BlockState m_5573_(BlockPlaceContext c) {
        return (BlockState)this.getState(this.m_49966_(), (BlockGetter)c.m_43725_(), c.m_8083_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(c.m_43725_().m_6425_(c.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return super.m_7361_(level, pos, state, fluidStateIn);
    }

    public boolean m_6044_(@Nullable Player p_298313_, BlockGetter p_56301_, BlockPos p_56302_, BlockState p_56303_, Fluid p_56304_) {
        return super.m_6044_(p_298313_, p_56301_, p_56302_, p_56303_, p_56304_);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        if (type == PathComputationType.WATER) {
            return level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        }
        return false;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return this.getState(stateIn, (BlockGetter)level, currentPos);
    }
}

