/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.cupboard;

import github.mrh0.buildersaddition2.blocks.blockstate.CupboardState;
import github.mrh0.buildersaddition2.blocks.cupboard.CupboardBlock;
import github.mrh0.buildersaddition2.common.BlockBlueprint;
import github.mrh0.buildersaddition2.common.datagen.BPBlockModelProvider;
import github.mrh0.buildersaddition2.common.datagen.BPBlockStateProvider;
import github.mrh0.buildersaddition2.common.datagen.BPItemModelProvider;
import github.mrh0.buildersaddition2.common.variants.WoodVariant;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.RegistryObject;

public class CupboardBlueprint
extends BlockBlueprint<WoodVariant, CupboardBlock> {
    public CupboardBlueprint(Iterable<WoodVariant> variants) {
        super(variants);
    }

    @Override
    public String getBaseName() {
        return "cupboard";
    }

    @Override
    public String getLangName(WoodVariant variant) {
        return variant.getDisplayName() + " Cupboard";
    }

    @Override
    public List<TagKey<Block>> addBlockTags(WoodVariant variant) {
        return List.of(BlockTags.f_144280_);
    }

    @Override
    protected Supplier<CupboardBlock> getBlock(WoodVariant variant) {
        return () -> new CupboardBlock(BlockBehaviour.Properties.m_308003_((BlockBehaviour)variant.planks));
    }

    @Override
    protected void buildBlockModel(BPBlockModelProvider provider, RegistryObject<CupboardBlock> block, WoodVariant variant) {
        ((BlockModelBuilder)((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant, "_single"), this.resource("block/base_cupboard_single")).texture("planks", variant.texturePlanks)).texture("stripped", variant.textureStripped)).texture("particle", variant.texturePlanks);
        ((BlockModelBuilder)((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant, "_single_mirror"), this.resource("block/base_cupboard_single_mirror")).texture("planks", variant.texturePlanks)).texture("stripped", variant.textureStripped)).texture("particle", variant.texturePlanks);
        ((BlockModelBuilder)((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant, "_top"), this.resource("block/base_cupboard_top")).texture("planks", variant.texturePlanks)).texture("stripped", variant.textureStripped)).texture("particle", variant.texturePlanks);
        ((BlockModelBuilder)((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant, "_top_mirror"), this.resource("block/base_cupboard_top_mirror")).texture("planks", variant.texturePlanks)).texture("stripped", variant.textureStripped)).texture("particle", variant.texturePlanks);
        ((BlockModelBuilder)((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant, "_bottom"), this.resource("block/base_cupboard_bottom")).texture("planks", variant.texturePlanks)).texture("stripped", variant.textureStripped)).texture("particle", variant.texturePlanks);
    }

    @Override
    protected void buildItemModel(BPItemModelProvider provider, RegistryObject<CupboardBlock> block, WoodVariant variant) {
        provider.withParent(this.getRegistryName(variant), this.resource(this.getBlockModelPath(variant, "_single")));
    }

    @Override
    public void buildBlockState(BPBlockStateProvider provider, RegistryObject<CupboardBlock> block, WoodVariant variant) {
        Function<BlockState, ModelFile> modelFunc = state -> {
            boolean mirror = (Boolean)state.m_61143_((Property)CupboardBlock.MIRROR);
            return switch ((CupboardState)((Object)((Object)state.m_61143_(CupboardBlock.VARIANT)))) {
                default -> throw new IncompatibleClassChangeError();
                case CupboardState.SINGLE -> {
                    if (mirror) {
                        yield this.blockModel(variant + "_cupboard_single_mirror");
                    }
                    yield this.blockModel(variant + "_cupboard_single");
                }
                case CupboardState.TOP -> {
                    if (mirror) {
                        yield this.blockModel(variant + "_cupboard_top_mirror");
                    }
                    yield this.blockModel(variant + "_cupboard_top");
                }
                case CupboardState.BOTTOM -> this.blockModel(variant + "_cupboard_bottom");
            };
        };
        provider.getVariantBuilder((Block)block.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build());
    }

    @Override
    public int getRecipeResultCount(WoodVariant variant) {
        return 1;
    }

    @Override
    public List<ItemLike> getRecipeRequired(WoodVariant variant) {
        return List.of(variant.planks, Blocks.f_50087_);
    }
}

