/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.cupboard;

import github.mrh0.buildersaddition2.BA2;
import github.mrh0.buildersaddition2.Index;
import github.mrh0.buildersaddition2.blocks.blockstate.CupboardState;
import github.mrh0.buildersaddition2.blocks.cupboard.CupboardBlockEntity;
import java.util.Optional;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CupboardBlock
extends Block
implements EntityBlock {
    public static final EnumProperty<CupboardState> VARIANT = EnumProperty.m_61587_((String)"variant", CupboardState.class);
    public static final BooleanProperty MIRROR = BooleanProperty.m_61465_((String)"mirror");
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static VoxelShape SHAPE_NORTH_SINGLE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0);
    private static VoxelShape SHAPE_EAST_SINGLE = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static VoxelShape SHAPE_SOUTH_SINGLE = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0);
    private static VoxelShape SHAPE_WEST_SINGLE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);
    private static VoxelShape SHAPE_NORTH_TOP = Block.m_49796_((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0);
    private static VoxelShape SHAPE_EAST_TOP = Block.m_49796_((double)1.0, (double)-16.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static VoxelShape SHAPE_SOUTH_TOP = Block.m_49796_((double)0.0, (double)-16.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0);
    private static VoxelShape SHAPE_WEST_TOP = Block.m_49796_((double)0.0, (double)-16.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);
    private static VoxelShape SHAPE_NORTH_BOTTOM = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)15.0);
    private static VoxelShape SHAPE_EAST_BOTTOM = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
    private static VoxelShape SHAPE_SOUTH_BOTTOM = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)32.0, (double)16.0);
    private static VoxelShape SHAPE_WEST_BOTTOM = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)32.0, (double)16.0);
    private static final DoubleBlockCombiner.Combiner<CupboardBlockEntity, Optional<Container>> CUPBOARD_COMBINER = new DoubleBlockCombiner.Combiner<CupboardBlockEntity, Optional<Container>>(){

        public Optional<Container> acceptDouble(CupboardBlockEntity be1, CupboardBlockEntity be2) {
            return Optional.of(new CompoundContainer((Container)be1, (Container)be2));
        }

        public Optional<Container> acceptSingle(CupboardBlockEntity be) {
            return Optional.of(be);
        }

        public Optional<Container> acceptNone() {
            return Optional.empty();
        }
    };
    private static final DoubleBlockCombiner.Combiner<CupboardBlockEntity, Optional<MenuProvider>> MENU_PROVIDER_COMBINER = new DoubleBlockCombiner.Combiner<CupboardBlockEntity, Optional<MenuProvider>>(){

        public Optional<MenuProvider> acceptDouble(final CupboardBlockEntity be1, final CupboardBlockEntity be2) {
            CompoundContainer container = new CompoundContainer((Container)be1, (Container)be2);
            return Optional.of(new MenuProvider(){
                final /* synthetic */ Container val$container;
                {
                    this.val$container = container;
                }

                @javax.annotation.Nullable
                public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
                    if (be1.m_7525_(player) && be2.m_7525_(player)) {
                        be1.m_306438_(inv.f_35978_);
                        be2.m_306438_(inv.f_35978_);
                        return ChestMenu.m_39246_((int)id, (Inventory)inv, (Container)this.val$container);
                    }
                    return null;
                }

                public Component m_5446_() {
                    if (be1.m_8077_()) {
                        return be1.m_5446_();
                    }
                    return be2.m_8077_() ? be2.m_5446_() : BA2.translatable("container", "cupboard");
                }
            });
        }

        public Optional<MenuProvider> acceptSingle(CupboardBlockEntity be) {
            return Optional.of(be);
        }

        public Optional<MenuProvider> acceptNone() {
            return Optional.empty();
        }
    };

    public CupboardBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        MenuProvider menuprovider = this.m_7246_(state, level, pos);
        if (menuprovider != null) {
            player.m_5893_(menuprovider);
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{VARIANT, MIRROR, FACING});
    }

    private static VoxelShape selectByDirection(Direction dir, VoxelShape north, VoxelShape east, VoxelShape south, VoxelShape west) {
        return switch (dir) {
            case Direction.EAST -> east;
            case Direction.SOUTH -> south;
            case Direction.WEST -> west;
            default -> north;
        };
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext cc) {
        return switch ((CupboardState)((Object)state.m_61143_(VARIANT))) {
            default -> throw new IncompatibleClassChangeError();
            case CupboardState.SINGLE -> CupboardBlock.selectByDirection((Direction)state.m_61143_((Property)FACING), SHAPE_NORTH_SINGLE, SHAPE_EAST_SINGLE, SHAPE_SOUTH_SINGLE, SHAPE_WEST_SINGLE);
            case CupboardState.TOP -> CupboardBlock.selectByDirection((Direction)state.m_61143_((Property)FACING), SHAPE_NORTH_TOP, SHAPE_EAST_TOP, SHAPE_SOUTH_TOP, SHAPE_WEST_TOP);
            case CupboardState.BOTTOM -> CupboardBlock.selectByDirection((Direction)state.m_61143_((Property)FACING), SHAPE_NORTH_BOTTOM, SHAPE_EAST_BOTTOM, SHAPE_SOUTH_BOTTOM, SHAPE_WEST_BOTTOM);
        };
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext c) {
        boolean shift = c.m_43723_() != null && c.m_43723_().m_36341_();
        BlockState aboveState = c.m_43725_().m_8055_(c.m_8083_().m_7494_());
        BlockState belowState = c.m_43725_().m_8055_(c.m_8083_().m_7495_());
        if (aboveState.m_60734_() instanceof CupboardBlock && !((CupboardState)((Object)aboveState.m_61143_(VARIANT))).isBottom() && aboveState.m_61143_((Property)FACING) == c.m_8125_()) {
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(VARIANT, (Comparable)((Object)CupboardState.BOTTOM))).m_61124_((Property)MIRROR, (Comparable)((Boolean)aboveState.m_61143_((Property)MIRROR)))).m_61124_((Property)FACING, (Comparable)c.m_8125_());
        }
        if (belowState.m_60734_() instanceof CupboardBlock && !((CupboardState)((Object)belowState.m_61143_(VARIANT))).isTop() && belowState.m_61143_((Property)FACING) == c.m_8125_()) {
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(VARIANT, (Comparable)((Object)CupboardState.TOP))).m_61124_((Property)MIRROR, (Comparable)((Boolean)belowState.m_61143_((Property)MIRROR)))).m_61124_((Property)FACING, (Comparable)c.m_8125_());
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(VARIANT, (Comparable)((Object)CupboardState.SINGLE))).m_61124_((Property)MIRROR, (Comparable)Boolean.valueOf(shift))).m_61124_((Property)FACING, (Comparable)c.m_8125_());
    }

    public BlockState m_7417_(BlockState currentState, Direction direction, BlockState newState, LevelAccessor level, BlockPos myPos, BlockPos otherPos) {
        if (!(currentState.m_60734_() instanceof CupboardBlock)) {
            return currentState;
        }
        if (newState.m_60734_() instanceof CupboardBlock) {
            if (currentState.m_61143_((Property)FACING) != newState.m_61143_((Property)FACING)) {
                return currentState;
            }
            if (currentState.m_61143_((Property)MIRROR) != newState.m_61143_((Property)MIRROR)) {
                return currentState;
            }
            if (!((CupboardState)((Object)currentState.m_61143_(VARIANT))).isSingle()) {
                return currentState;
            }
            if (direction == Direction.DOWN && !((CupboardState)((Object)newState.m_61143_(VARIANT))).isTop()) {
                return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(VARIANT, (Comparable)((Object)CupboardState.TOP))).m_61124_((Property)FACING, (Comparable)((Direction)currentState.m_61143_((Property)FACING)))).m_61124_((Property)MIRROR, (Comparable)((Boolean)currentState.m_61143_((Property)MIRROR)));
            }
            if (direction == Direction.UP && !((CupboardState)((Object)newState.m_61143_(VARIANT))).isBottom()) {
                return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(VARIANT, (Comparable)((Object)CupboardState.BOTTOM))).m_61124_((Property)FACING, (Comparable)((Direction)currentState.m_61143_((Property)FACING)))).m_61124_((Property)MIRROR, (Comparable)((Boolean)currentState.m_61143_((Property)MIRROR)));
            }
        } else if (direction == Direction.DOWN && ((CupboardState)((Object)currentState.m_61143_(VARIANT))).isTop() || direction == Direction.UP && ((CupboardState)((Object)currentState.m_61143_(VARIANT))).isBottom()) {
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(VARIANT, (Comparable)((Object)CupboardState.SINGLE))).m_61124_((Property)FACING, (Comparable)((Direction)currentState.m_61143_((Property)FACING)))).m_61124_((Property)MIRROR, (Comparable)((Boolean)currentState.m_61143_((Property)MIRROR)));
        }
        return super.m_7417_(currentState, direction, newState, level, myPos, otherPos);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (level.m_5776_()) {
            return;
        }
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)container);
            level.m_46672_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CupboardBlockEntity(pos, state);
    }

    public static DoubleBlockCombiner.BlockType getBlockType(BlockState state) {
        CupboardState type = (CupboardState)((Object)state.m_61143_(VARIANT));
        if (type == CupboardState.SINGLE) {
            return DoubleBlockCombiner.BlockType.SINGLE;
        }
        return type == CupboardState.TOP ? DoubleBlockCombiner.BlockType.FIRST : DoubleBlockCombiner.BlockType.SECOND;
    }

    public static Direction getConnectedDirection(BlockState state) {
        return state.m_61143_(VARIANT) == CupboardState.BOTTOM ? Direction.UP : Direction.DOWN;
    }

    public static Container getContainer(CupboardBlock block, BlockState state, Level level, BlockPos pos, boolean flag) {
        return ((Optional)block.combine(state, level, pos, flag).m_5649_(CUPBOARD_COMBINER)).orElse(null);
    }

    public DoubleBlockCombiner.NeighborCombineResult<? extends CupboardBlockEntity> combine(BlockState p_51544_, Level p_51545_, BlockPos p_51546_, boolean p_51547_) {
        BiPredicate<LevelAccessor, BlockPos> bipredicate = (level, pos) -> false;
        return DoubleBlockCombiner.m_52822_((BlockEntityType)((BlockEntityType)Index.CUPBOARD_ENTITY_TYPE.get()), CupboardBlock::getBlockType, CupboardBlock::getConnectedDirection, (DirectionProperty)FACING, (BlockState)p_51544_, (LevelAccessor)p_51545_, (BlockPos)p_51546_, bipredicate);
    }

    public MenuProvider m_7246_(BlockState state, Level level, BlockPos pos) {
        return ((Optional)this.combine(state, level, pos, false).m_5649_(MENU_PROVIDER_COMBINER)).orElse(null);
    }
}

