/*
 * Decompiled with CFR 0.152.
 */
package github.mrh0.buildersaddition2.blocks.counter;

import github.mrh0.buildersaddition2.blocks.counter.CounterBlock;
import github.mrh0.buildersaddition2.common.BlockBlueprint;
import github.mrh0.buildersaddition2.common.datagen.BPBlockModelProvider;
import github.mrh0.buildersaddition2.common.datagen.BPBlockStateProvider;
import github.mrh0.buildersaddition2.common.datagen.BPItemModelProvider;
import github.mrh0.buildersaddition2.common.variants.CounterVariant;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.registries.RegistryObject;

public class CounterBlueprint
extends BlockBlueprint<CounterVariant, CounterBlock> {
    public CounterBlueprint(Iterable<CounterVariant> variants) {
        super(variants);
    }

    @Override
    public String getBaseName() {
        return "counter";
    }

    @Override
    public String getLangName(CounterVariant variant) {
        return variant.getDisplayName() + " Counter";
    }

    @Override
    public List<TagKey<Block>> addBlockTags(CounterVariant variant) {
        return List.of(BlockTags.f_144280_);
    }

    @Override
    protected Supplier<CounterBlock> getBlock(CounterVariant variant) {
        return () -> new CounterBlock(BlockBehaviour.Properties.m_308003_((BlockBehaviour)variant.wood.planks));
    }

    @Override
    protected void buildBlockModel(BPBlockModelProvider provider, RegistryObject<CounterBlock> block, CounterVariant variant) {
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.withParent(this.getBlockModelPath(variant), this.resource("block/base_" + this.getBaseName())).texture("top", variant.textureTop)).texture("planks", variant.wood.texturePlanks)).texture("stripped", variant.wood.textureStripped)).texture("particle", variant.wood.texturePlanks);
    }

    @Override
    protected void buildItemModel(BPItemModelProvider provider, RegistryObject<CounterBlock> block, CounterVariant variant) {
        provider.withParent(this.getRegistryName(variant), this.resource(this.getBlockModelPath(variant)));
    }

    @Override
    public void buildBlockState(BPBlockStateProvider provider, RegistryObject<CounterBlock> block, CounterVariant variant) {
        provider.horizontalBlock((Block)block.get(), this.model(this.getBlockModelPath(variant)));
    }

    @Override
    public int getRecipeResultCount(CounterVariant variant) {
        return 1;
    }

    @Override
    public List<ItemLike> getRecipeRequired(CounterVariant variant) {
        return List.of(variant.wood.planks, Blocks.f_50087_, variant.top);
    }
}

